<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="max-w-2xl mx-auto">
        <div class="mb-6">
            <a href="<?php echo e(route('admin.card.requests')); ?>" class="text-gray-400 hover:text-white flex items-center gap-2">
                &larr; Back to Requests
            </a>
        </div>

        <div class="bg-[#131319] rounded-lg p-8 border border-gray-700 shadow-lg">
            <div class="flex justify-between items-start mb-8">
                <div>
                    <h1 class="text-2xl font-bold text-white">Review Card Details</h1>
                    <p class="text-gray-400 mt-1">Submitted by: <span class="text-white"><?php echo e($request->user->firstname); ?> <?php echo e($request->user->lastname); ?></span></p>
                </div>
                <div class="px-3 py-1 bg-yellow-500/10 border border-yellow-500/50 text-yellow-500 rounded text-xs uppercase font-bold">
                    Pending
                </div>
            </div>

            
            <div class="bg-gray-800 rounded-xl p-6 border border-gray-600 mb-8 space-y-6">

                <div class="grid grid-cols-2 gap-4 border-b border-gray-700 pb-4">
                    <div>
                        <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1">Cardholder Name</label>
                        <p class="text-lg text-white font-mono"><?php echo e($decryptedDetails['name']); ?></p>
                    </div>
                    <div>
                        <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1">Expiry Date</label>
                        <p class="text-lg text-white font-mono"><?php echo e($decryptedDetails['expiry']); ?></p>
                    </div>
                </div>

                <div class="border-b border-gray-700 pb-4">
                    <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1">Card Number</label>
                    <div class="flex items-center justify-between">
                        <p class="text-2xl text-white font-mono tracking-wider"><?php echo e(chunk_split($decryptedDetails['number'], 4, ' ')); ?></p>
                        <button onclick="navigator.clipboard.writeText('<?php echo e($decryptedDetails['number']); ?>')" class="text-indigo-400 hover:text-indigo-300 text-sm">Copy</button>
                    </div>
                </div>

                <div>
                    <label class="block text-xs font-bold text-gray-500 uppercase tracking-wider mb-1">CVV / CVC</label>
                    <p class="text-lg text-red-400 font-mono font-bold"><?php echo e($decryptedDetails['cvv']); ?></p>
                </div>
            </div>

            
            <div class="grid grid-cols-2 gap-4">
                
                <form action="<?php echo e(route('admin.card.reject', $request->id)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to REJECT this card? The user will be notified.');">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="w-full py-3 px-4 bg-red-600/10 border border-red-600 text-red-500 font-bold rounded-lg hover:bg-red-600 hover:text-white transition-all">
                        Reject Card
                    </button>
                </form>

                
                <form action="<?php echo e(route('admin.card.approve', $request->id)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to APPROVE this card? It will become active immediately.');">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="w-full py-3 px-4 bg-green-600 text-white font-bold rounded-lg hover:bg-green-500 shadow-lg shadow-green-600/20 transition-all">
                        Approve & Activate
                    </button>
                </form>
            </div>

        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\exodus-clone-laravel\resources\views/admin/card/review.blade.php ENDPATH**/ ?>