<?php
    // Direct Query for Active Persona (Efficient & Simple)
    $activePersona = \App\Models\Persona::where('is_active', true)->first();

    // Fallback Defaults (in case no active persona is found)
    $appName = $activePersona->name ?? config('app.name', 'Stackvault');
    $appLogo = $activePersona->logo_full_path
        ? asset('storage/' . $activePersona->logo_full_path)
        : ($activePersona->logo_path ? asset('storage/' . $activePersona->logo_path) : asset('images/logo-v2.png'));

    $appFavicon = $activePersona->logo_path
        ? asset('storage/' . $activePersona->logo_path)
        : asset('images/favicon.png');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title id="app-title"><?php echo e($appName); ?> | Dashboard</title>

    <link href="<?php echo e(asset('build/assets/built.css')); ?>" rel="stylesheet" />
    <script src="<?php echo e(asset('build/assets/app2.js')); ?>"></script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    
    <link id="app-favicon" rel="shortcut icon" href="<?php echo e($appFavicon); ?>" type="image/x-icon">

    <style>
        /* Custom Font */
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        body { font-family: 'Inter', sans-serif; }

        /* Scrollbar */
        *::-webkit-scrollbar { width: 6px; }
        *::-webkit-scrollbar-track { background: transparent; }
        *::-webkit-scrollbar-thumb { background-color: #CBD5E1; border-radius: 10px; }

        /* Dynamic Brand Color (Optional: If you want to use the color from DB) */
        :root {
            --brand-primary: <?php echo e($activePersona->primary_color ?? '#4F46E5'); ?>;
        }
    </style>
</head>
<body class="bg-[#F8F9FB] text-slate-800 font-sans antialiased">
    <div class="flex h-screen overflow-hidden">

        
        <div id="sidebar" class="fixed inset-y-0 left-0 z-50 w-72 bg-white transform -translate-x-full transition-transform duration-300 ease-in-out lg:translate-x-0 lg:static lg:inset-0 border-r border-gray-100 flex flex-col shadow-[4px_0_24px_rgba(0,0,0,0.02)]">

            
            <div class="px-8 pt-8 pb-2">
                <img id="sidebar-logo"
                     src="<?php echo e($appLogo); ?>"
                     alt="<?php echo e($appName); ?>"
                     class="h-8 w-auto object-contain transition-all duration-300">
            </div>

            <div class="flex-1 flex flex-col justify-between overflow-y-auto">
                <div>
                    
                    <div class="px-8 py-6">
                        <div class="flex flex-col md:flex-row items-center gap-4 mb-2">
                            <div id="user-initials-circle" class="w-12 h-12 bg-gray-100 rounded-full flex items-center justify-center text-gray-600 font-bold text-lg overflow-hidden border border-gray-100">
                                <?php if(Auth::user()->kyc): ?>
                                    <img id="preview-imgx"
                                        src="<?php echo e(asset('storage/' . Auth::user()->profile_photo)); ?>"
                                        alt="Profile"
                                        class="w-full h-full object-cover">
                                <?php else: ?>
                                    <img id="preview-img"
                                        src="https://ui-avatars.com/api/?name=<?php echo e(Auth::user()->firstname); ?>+<?php echo e(Auth::user()->lastname); ?>&background=eef2ff&color=4f46e5"
                                        class="w-full h-full object-cover">
                                <?php endif; ?>
                            </div>
                            <div class="text-center md:text-left">
                                <h4 class="text-base font-bold text-slate-900 leading-tight">
                                    <?php if(Auth::check()): ?><?php echo e(Auth::user()->firstname); ?> <?php echo e(Auth::user()->lastname); ?><?php else: ?> User <?php endif; ?>
                                </h4>
                                <p class="text-xs text-gray-400 font-medium">Financial Advisor</p>
                            </div>
                        </div>
                    </div>

                    
                    <nav class="px-6 space-y-1">
                        <?php if(Auth::check() && Auth::user()->role_id === 1): ?>
                            <?php if (isset($component)) { $__componentOriginald4f2c5a8a855d7eaab370019aec68dd9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald4f2c5a8a855d7eaab370019aec68dd9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin-navigation','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-navigation'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald4f2c5a8a855d7eaab370019aec68dd9)): ?>
<?php $attributes = $__attributesOriginald4f2c5a8a855d7eaab370019aec68dd9; ?>
<?php unset($__attributesOriginald4f2c5a8a855d7eaab370019aec68dd9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald4f2c5a8a855d7eaab370019aec68dd9)): ?>
<?php $component = $__componentOriginald4f2c5a8a855d7eaab370019aec68dd9; ?>
<?php unset($__componentOriginald4f2c5a8a855d7eaab370019aec68dd9); ?>
<?php endif; ?>
                        <?php else: ?>
                            
                            <a href="/dashboard" class="flex items-center px-4 py-3.5 text-sm font-medium rounded-xl transition-all group <?php echo e(Request::is('dashboard') ? 'bg-indigo-600 text-white shadow-lg shadow-indigo-500/30' : 'text-gray-500 hover:text-gray-900 hover:bg-gray-50'); ?>">
                                <i data-lucide="layout-grid" class="w-5 h-5 mr-3 <?php echo e(Request::is('dashboard') ? 'text-white' : 'text-gray-400 group-hover:text-gray-600'); ?>"></i>
                                Dashboard
                            </a>

                            <a href="/user/cards" class="flex items-center px-4 py-3.5 text-sm font-medium rounded-xl transition-all group <?php echo e(Request::is('user/cards') ? 'bg-indigo-600 text-white shadow-lg shadow-indigo-500/30' : 'text-gray-500 hover:text-gray-900 hover:bg-gray-50'); ?>">
                                <i data-lucide="credit-card" class="w-5 h-5 mr-3 <?php echo e(Request::is('user/cards') ? 'text-white' : 'text-gray-400 group-hover:text-gray-600'); ?>"></i>
                                My Card
                            </a>

                            <a href="/transaction-history" class="flex items-center px-4 py-3.5 text-sm font-medium rounded-xl transition-all group <?php echo e(Request::is('transaction-history') ? 'bg-indigo-600 text-white shadow-lg shadow-indigo-500/30' : 'text-gray-500 hover:text-gray-900 hover:bg-gray-50'); ?>">
                                <i data-lucide="bar-chart-2" class="w-5 h-5 mr-3 <?php echo e(Request::is('transaction-history') ? 'text-white' : 'text-gray-400 group-hover:text-gray-600'); ?>"></i>
                                Transactions
                            </a>

                            <a href="/kyc" class="flex items-center justify-between px-4 py-3.5 text-sm font-medium rounded-xl transition-all group <?php echo e(Request::is('kyc') ? 'bg-indigo-600 text-white shadow-lg shadow-indigo-500/30' : 'text-gray-500 hover:text-gray-900 hover:bg-gray-50'); ?>">
                                <div class="flex items-center">
                                    <i data-lucide="shield" class="w-5 h-5 mr-3 <?php echo e(Request::is('kyc') ? 'text-white' : 'text-gray-400 group-hover:text-gray-600'); ?>"></i>
                                    KYC
                                </div>
                                <?php if(!Auth::user()->kyc): ?>
                                    <span class="w-2 h-2 rounded-full bg-red-500"></span>
                                <?php endif; ?>
                            </a>

                            <a href="/referral" class="flex items-center justify-between px-4 py-3.5 text-sm font-medium rounded-xl transition-all group <?php echo e(Request::is('referral') ? 'bg-indigo-600 text-white shadow-lg shadow-indigo-500/30' : 'text-gray-500 hover:text-gray-900 hover:bg-gray-50'); ?>">
                                <div class="flex items-center">
                                    <i data-lucide="user-plus" class="w-5 h-5 mr-3 <?php echo e(Request::is('referral') ? 'text-white' : 'text-gray-400 group-hover:text-gray-600'); ?>"></i>
                                    Referral
                                </div>
                            </a>
                        <?php endif; ?>
                    </nav>
                </div>

                
                <div class="px-6 mb-8 space-y-1">
                    <a href="/user/profile" class="flex items-center px-4 py-3 text-sm font-medium rounded-xl text-gray-500 hover:text-gray-900 hover:bg-gray-50 transition-colors">
                        <i data-lucide="user-circle" class="w-5 h-5 mr-3 text-gray-400"></i>
                        My Account
                    </a>
                    <a href="#" class="flex items-center px-4 py-3 text-sm font-medium rounded-xl text-gray-500 hover:text-gray-900 hover:bg-gray-50 transition-colors">
                        <i data-lucide="headset" class="w-5 h-5 mr-3 text-gray-400"></i>
                        Help Center
                    </a>
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="flex w-full items-center px-4 py-3 text-sm font-medium rounded-xl text-gray-500 hover:text-red-600 hover:bg-red-50 transition-colors">
                            <i data-lucide="log-out" class="w-5 h-5 mr-3 text-gray-400"></i>
                            Logout
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div id="sidebarOverlay" class="fixed inset-0 z-40 bg-gray-900 bg-opacity-50 lg:hidden hidden backdrop-blur-sm"></div>

        
        <div class="flex-1 flex flex-col overflow-hidden bg-[#F8F9FB]">
            
            <header class="bg-white h-16 flex items-center justify-between px-6 border-b border-gray-100 lg:hidden shadow-sm">
                <button id="openSidebar" class="text-gray-500 hover:text-gray-900">
                    <i data-lucide="menu" class="w-6 h-6"></i>
                </button>

                
                <div class="h-8">
                    <img id="mobile-logo"
                         src="<?php echo e($appLogo); ?>"
                         alt="<?php echo e($appName); ?>"
                         class="h-full w-auto object-contain">
                </div>

                <div class="w-6"></div>
            </header>

            <main class="flex-1 overflow-y-auto">
                <div class="p-8 lg:p-12 max-w-[1600px] mx-auto">
                    <?php echo e($slot); ?>

                </div>
            </main>
        </div>
    </div>

    
    <script>
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('sidebarOverlay');
        const openBtn = document.getElementById('openSidebar');

        function toggleSidebar(show) {
            if(show) {
                sidebar.classList.remove('-translate-x-full');
                overlay.classList.remove('hidden');
            } else {
                sidebar.classList.add('-translate-x-full');
                overlay.classList.add('hidden');
            }
        }

        if(openBtn) openBtn.addEventListener('click', () => toggleSidebar(true));
        if(overlay) overlay.addEventListener('click', () => toggleSidebar(false));

        document.addEventListener('DOMContentLoaded', () => {
            lucide.createIcons();
        });
    </script>
    <?php if (isset($component)) { $__componentOriginalec1baae1b3da30b33d750352f80db369 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalec1baae1b3da30b33d750352f80db369 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.toast-group','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('toast-group'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalec1baae1b3da30b33d750352f80db369)): ?>
<?php $attributes = $__attributesOriginalec1baae1b3da30b33d750352f80db369; ?>
<?php unset($__attributesOriginalec1baae1b3da30b33d750352f80db369); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalec1baae1b3da30b33d750352f80db369)): ?>
<?php $component = $__componentOriginalec1baae1b3da30b33d750352f80db369; ?>
<?php unset($__componentOriginalec1baae1b3da30b33d750352f80db369); ?>
<?php endif; ?>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\exodus-clone-laravel\resources\views/layouts/user.blade.php ENDPATH**/ ?>