<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <section class="p-4 sm:p-6 lg:p-8 pt-0">
        <div class="mx-auto max-w-full">
            <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6">
                <h1 class="text-2xl font-semibold text-white flex items-center">
                    <svg data-lucide="line-chart" class="w-8 h-8 mr-3 text-green-500"></svg>
                    Stake Funds
                </h1>
                <div class="mt-2 sm:mt-0">
                    <a href="<?php echo e(route('portfolio')); ?>"
                       class="inline-flex items-center px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-lg text-sm font-semibold transition-colors duration-200">
                        <svg data-lucide="eye" class="mr-2 w-4 h-4"></svg>
                        View My Active Stakes
                    </a>
                </div>
            </div>
        </div>
    </section>
    <section class="px-4 sm:px-6 lg:px-8 pb-4">
        <div class="max-w-full mx-auto">
            <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
                <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center">
                    <div class="flex-1 mb-4 sm:mb-0">
                        <h4 class="flex items-center text-green-500 text-lg sm:text-xl font-semibold">
                            <svg data-lucide="wallet" class="w-6 h-6 mr-2"></svg>
                            Wallet Balance
                        </h4>
                        <div class="mt-2">
                            <p class="text-3xl md:text-4xl lg:text-5xl font-bold text-white">$<?php echo e(number_format(Auth::user()->wallet->totalBalance ?? 0, 2, '.', ',')); ?></p>
                        </div>
                    </div>
                    <div class="flex-shrink-0 text-right w-full sm:w-auto">
                        <div class="flex justify-end items-center h-full">
                            <svg data-lucide="wallet" class="w-16 h-16 text-green-500"></svg>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="px-4 sm:px-6 lg:px-8 mt-6">
        <div id="investment_plans_list" class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
            <div class="border-b border-gray-700 pb-4 mb-6">
                <h4 class="font-bold text-xl text-white text-center">Select from our list of available Plans</h4>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 max-w-7xl mx-auto">
                <?php $__currentLoopData = $investment_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inv_plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                $is_eligible = (Auth::user()->wallet->totalBalance >= $inv_plan->min_investment);
                //dd(Auth::user()->wallet->totalBalance, $is_eligible);
                $expected_return = $inv_plan->daily_roi_percentage * 0.01 * $inv_plan->min_investment * $inv_plan->min_duration_value;
                ?>
                <div class="relative bg-gray-700 rounded-lg xp-6 flex flex-col items-center justify-between transition-all duration-200 border
                                <?php echo e($is_eligible ? 'hover:border-primary-500 hover:shadow-lg cursor-pointer' : 'opacity-70 cursor-not-allowed'); ?>"
                     onclick="openInvestModal(
                                        <?php echo e($inv_plan->id); ?>,
                                        '<?php echo e($inv_plan->name); ?>',
                                        <?php echo e($inv_plan->min_investment); ?>,
                                        <?php echo e($inv_plan->max_investment); ?>,
                                        <?php echo e($inv_plan->daily_roi_percentage); ?>,
                                        <?php echo e($inv_plan->min_duration_value); ?>,
                                        <?php echo e($inv_plan->max_duration_value); ?>,
                                        <?php echo e(json_encode($inv_plan->allowed_duration_units ?? ['days'])); ?>,
                                        `<?php echo e(str_replace('`', '\\`', $inv_plan->description)); ?>`,
                                        <?php echo e($inv_plan->features ? json_encode($inv_plan->features) : '[]'); ?>

                                    )"
                     id="investment-plan-<?php echo e($inv_plan->id); ?>">
                    <div>
                        <div class="xabsolute top-0 left-0 w-full bg-primary-600 text-white text-center py-2 rounded-t-lg text-lg font-bold">
                            <?php echo e($inv_plan->name); ?>

                        </div>
                        <div class="p-6">
                            <p class="xmt-12 text-sm text-gray-300 text-center mb-4 min-h-[40px]"><?php echo e($inv_plan->description); ?></p>
                            <div class="mb-4 space-y-2 w-full text-left">
                                <div class="flex items-center justify-between text-gray-300 text-sm">
                                    <span>Min. Capital:</span>
                                    <span class="font-bold text-white text-right">$<?php echo e(number_format($inv_plan->min_investment, 2)); ?></span>
                                </div>
                                <div class="flex items-center justify-between text-gray-300 text-sm">
                                    <span>Max. Capital:</span>
                                    <span class="font-bold text-white text-right">$<?php echo e(number_format($inv_plan->max_investment, 2)); ?></span>
                                </div>
                                <div class="flex items-center justify-between text-gray-300 text-sm">
                                    <span>Daily ROI:</span>
                                    <span class="font-bold text-green-400 text-right"><?php echo e($inv_plan->daily_roi_percentage); ?>%</span>
                                </div>
                                <div class="flex items-center justify-between text-gray-300 text-sm">
                                    <span>Duration:</span>
                                    <span class="font-bold text-white"><?php echo e($inv_plan->min_duration_value); ?> - <?php echo e($inv_plan->max_duration_value); ?> <?php echo e(ucfirst($inv_plan->allowed_duration_units[0] ?? 'day')); ?><?php echo e(($inv_plan->max_duration_value > 1 || $inv_plan->min_duration_value > 1) ? 's' : ''); ?></span>
                                </div>
                                <div class="flex items-center justify-between text-gray-300 text-sm">
                                    <span>Expected Return:</span>
                                    <span class="font-bold text-yellow-400 text-right">$<?php echo e(number_format($expected_return, 2)); ?> <span class="text-xs font-normal text-gray-400">(Min. Duration)</span></span>
                                </div>
                            </div>
                            <div class="w-full text-left mb-4">
                                <span class="font-semibold text-gray-300">Features:</span>
                                <ul class="list-disc list-inside text-sm text-gray-400 space-y-1 pl-4">
                                    <?php if(!empty($inv_plan->features)): ?>
                                    <?php $__currentLoopData = $inv_plan->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(trim($feature) !== ''): ?>
                                    <li><?php echo e($feature); ?></li>
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <li>No specific features listed.</li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="p-6 flex flex-col w-full">
                        <?php if(!$is_eligible): ?>
                        <button type="button" disabled
                                class="w-full px-6 py-3 bg-red-700 text-white font-semibold rounded-lg opacity-70 cursor-not-allowed">
                            Insufficient Balance
                        </button>
                        <span class="block mt-2 text-red-400 text-center text-sm">
                            Please <a href="/deposit?amt=<?php echo e($inv_plan->min_investment); ?>" class="text-primary-400 underline hover:text-primary-300">add funds</a> to your wallet.
                        </span>
                        <?php else: ?>
                        <button type="button" onclick="openInvestModal(
                                        <?php echo e($inv_plan->id); ?>,
                                        '<?php echo e($inv_plan->name); ?>',
                                        <?php echo e($inv_plan->min_investment); ?>,
                                        <?php echo e($inv_plan->max_investment); ?>,
                                        <?php echo e($inv_plan->daily_roi_percentage); ?>,
                                        <?php echo e($inv_plan->min_duration_value); ?>,
                                        <?php echo e($inv_plan->max_duration_value); ?>,
                                        <?php echo e(json_encode($inv_plan->allowed_duration_units ?? ['days'])); ?>,
                                        `<?php echo e(str_replace('`', '\\`', $inv_plan->description)); ?>`,
                                        <?php echo e($inv_plan->features ? json_encode($inv_plan->features) : '[]'); ?>

                                    )"
                                class="w-full px-6 py-3 bg-primary-600 hover:bg-primary-700 text-white font-semibold rounded-lg transition-colors duration-200">
                            Invest Now
                        </button>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if($investment_plans->isEmpty()): ?>
                <div class="md:col-span-2 lg:col-span-3 text-center p-8 text-gray-400 text-xl">
                    No investment plans available at the moment.
                </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
    
    <?php if (isset($component)) { $__componentOriginal9f64f32e90b9102968f2bc548315018c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9f64f32e90b9102968f2bc548315018c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.modal','data' => ['id' => 'invest-now-modal']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'invest-now-modal']); ?>
        <div class="bg-[#131319] rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-gray-700">
            <div class="border-b border-gray-700 pb-4 mb-6">
                <h2 class="text-2xl font-bold text-white">Invest in <span id="modalPlanName"></span></h2>
                <p class="text-sm text-gray-400 mt-1">Daily ROI: <span id="modalDailyRoi" class="font-semibold text-green-400"></span>%</p>
                <p class="text-sm text-gray-400">Investment Range: $<span id="modalMinCapital"></span> - $<span id="modalMaxCapital"></span></p>
            </div>
            <form action="<?php echo e(route('investment.store')); ?>" method="POST" id="investForm">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="investment_plan_id" id="modalPlanId">
                <div class="space-y-4 text-left mb-6">
                    <div>
                        <label for="sourceWallet" class="block text-sm font-medium text-gray-300 mb-1">Source Wallet</label>
                        <select name="source_wallet_coin_id" id="sourceWallet" required
                                class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500">
                            <?php $__currentLoopData = Auth::user()->wallet->walletCoins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $walletCoin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($walletCoin->id); ?>" data-balance="<?php echo e($walletCoin->balance); ?>" data-value="<?php echo e($walletCoin->coin->value); ?>" class="capitalize"><?php echo e($walletCoin->coin->name); ?> (<?php echo e($walletCoin->coin->code); ?>) - Balance: $<?php echo e(number_format($walletCoin->balance * $walletCoin->coin->value, 2)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <p class="text-xs text-gray-400 mt-1">
                            Available balance: <span id="modalAvailableBalance"></span>
                        </p>
                    </div>
                    <div>
                        <label for="modalInvestedAmount" class="block text-sm font-medium text-gray-300 mb-1">Your Investment Amount (USD)</label>
                        <input type="number" name="invested_amount" id="modalInvestedAmount" step="0.01" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="modalUserChosenDurationValue" class="block text-sm font-medium text-gray-300 mb-1">Duration Value</label>
                        <input type="number" name="user_chosen_duration_value" id="modalUserChosenDurationValue" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="modalUserChosenDurationUnit" class="block text-sm font-medium text-gray-300 mb-1">Duration Unit</label>
                        <select name="user_chosen_duration_unit" id="modalUserChosenDurationUnit" required
                                class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500">
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-1">Features:</label>
                        <ul id="modalFeaturesList" class="list-disc list-inside text-sm text-gray-300 space-y-1 pl-4">
                        </ul>
                    </div>
                    <div class="text-white text-right">
                        <p class="text-sm text-gray-400">Expected Total Return:</p>
                        <p class="text-xl font-bold text-yellow-400" id="modalExpectedTotalReturn">$0.00</p>
                    </div>
                    <div class="text-xs text-red-400 text-center mt-2" id="modalInvestError"></div>
                </div>
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" id="modalConfirmButton" class="px-6 py-2 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-lg transition-colors duration-200">Confirm Investment</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('invest-now-modal')">Cancel</button>
                </div>
            </form>
        </div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9f64f32e90b9102968f2bc548315018c)): ?>
<?php $attributes = $__attributesOriginal9f64f32e90b9102968f2bc548315018c; ?>
<?php unset($__attributesOriginal9f64f32e90b9102968f2bc548315018c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9f64f32e90b9102968f2bc548315018c)): ?>
<?php $component = $__componentOriginal9f64f32e90b9102968f2bc548315018c; ?>
<?php unset($__componentOriginal9f64f32e90b9102968f2bc548315018c); ?>
<?php endif; ?>
    
    <?php if(session('success')): ?>
        <div id="success-alert-modal" class="fixed inset-0 bg-[#000] bg-opacity-75 flex items-center justify-center z-50 p-4" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="bg-green-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-green-600">
                <div class="text-center text-white mb-6">
                    <svg data-lucide="check-circle" class="mx-auto h-16 w-16 text-white"></svg>
                    <h2 class="mt-4 text-3xl font-bold">Investment Successful!</h2>
                    <p class="mt-2 text-xl">Investment ID: <?php echo e(session('investment_id')); ?></p>
                </div>
                <div class="flex flex-col sm:flex-row items-center justify-center gap-4">
                    <a href="<?php echo e(route('investment.index')); ?>" class="w-full sm:w-auto px-6 py-3 bg-white hover:bg-gray-100 text-green-700 font-semibold rounded-lg transition-colors duration-200">
                        Invest Again
                    </a>
                    <button type="button" class="w-full sm:w-auto px-6 py-3 bg-white hover:bg-gray-100 text-green-700 font-semibold rounded-lg transition-colors duration-200" onclick="document.getElementById('success-alert-modal').classList.add('hidden');">
                        Close
                    </button>
                </div>
            </div>
        </div>
        <script>
            document.addEventListener('DOMContentLoaded', () => {
                const modal = document.getElementById('success-alert-modal');
                if (modal) {
                    modal.classList.remove('hidden');
                }
            });
        </script>
    <?php endif; ?>
    <script>
        // Modal functions (assumed to be global)
        function openModal(modalId) {
            const modal = document.getElementById(modalId);
            if (modal) {
                modal.style.display = 'flex';
                document.body.style.overflow = 'hidden';
            }
        }
        function closeModal(modalId) {
            const modal = document.getElementById(modalId);
            if (modal) {
                modal.style.display = 'none';
                document.body.style.overflow = '';
            }
        }
        // Invest Details Modal Scripts
        const investNowModal = document.getElementById('invest-now-modal');
        const modalPlanId = document.getElementById('modalPlanId');
        const modalPlanName = document.getElementById('modalPlanName');
        const modalDailyRoi = document.getElementById('modalDailyRoi');
        const modalMinCapital = document.getElementById('modalMinCapital');
        const modalMaxCapital = document.getElementById('modalMaxCapital');
        const sourceWalletSelect = document.getElementById('sourceWallet');
        const modalAvailableBalance = document.getElementById('modalAvailableBalance');
        const modalFeaturesList = document.getElementById('modalFeaturesList');
        const modalInvestedAmount = document.getElementById('modalInvestedAmount');
        const modalExpectedTotalReturn = document.getElementById('modalExpectedTotalReturn');
        const modalInvestError = document.getElementById('modalInvestError');
        const modalConfirmButton = document.getElementById('modalConfirmButton');
        const modalUserChosenDurationValue = document.getElementById('modalUserChosenDurationValue');
        const modalUserChosenDurationUnit = document.getElementById('modalUserChosenDurationUnit');
        let currentPlanDailyRoi = 0;
        let currentPlanMinInvestment = 0;
        let currentPlanMaxInvestment = 0;
        let currentPlanMinDurationValue = 0;
        let currentPlanMaxDurationValue = 0;
        let currentPlanAllowedDurationUnits = [];
        let selectedWalletBalance = 0;
        function openInvestModal(id, name, minInvestment, maxInvestment, dailyRoiPercentage, minDurationValue, maxDurationValue, allowedDurationUnits, description, features) {
            modalPlanId.value = id;
            modalPlanName.textContent = name;
            modalDailyRoi.textContent = dailyRoiPercentage;
            modalMinCapital.textContent = minInvestment.toLocaleString();
            modalMaxCapital.textContent = maxInvestment.toLocaleString();
            modalInvestedAmount.min = minInvestment;
            modalInvestedAmount.max = maxInvestment;
            modalInvestedAmount.value = minInvestment;
            currentPlanDailyRoi = dailyRoiPercentage;
            currentPlanMinInvestment = minInvestment;
            currentPlanMaxInvestment = maxInvestment;
            currentPlanMinDurationValue = minDurationValue;
            currentPlanMaxDurationValue = maxDurationValue;
            currentPlanAllowedDurationUnits = allowedDurationUnits;
            modalUserChosenDurationValue.min = minDurationValue;
            modalUserChosenDurationValue.max = maxDurationValue;
            modalUserChosenDurationValue.value = minDurationValue;
            modalUserChosenDurationUnit.innerHTML = '';
            allowedDurationUnits.forEach(unit => {
                const option = document.createElement('option');
                option.value = unit;
                option.textContent = ucfirst(unit) + (minDurationValue > 1 ? 's' : '');
                modalUserChosenDurationUnit.appendChild(option);
            });
            modalUserChosenDurationUnit.value = allowedDurationUnits[0] || 'days';
            modalFeaturesList.innerHTML = '';
            features.forEach(feature => {
                if (feature.trim() !== '') {
                    const li = document.createElement('li');
                    li.textContent = feature;
                    modalFeaturesList.appendChild(li);
                }
            });
            modalInvestError.textContent = '';
            modalConfirmButton.disabled = false;
            modalConfirmButton.classList.remove('opacity-50', 'cursor-not-allowed');
            updateSelectedWalletBalance();
            updateExpectedTotalReturn();
            openModal('invest-now-modal');
        }
        function updateSelectedWalletBalance() {
            const selectedOption = sourceWalletSelect.options[sourceWalletSelect.selectedIndex];
            const balanceInCoin = parseFloat(selectedOption.dataset.balance);
            const coinValue = parseFloat(selectedOption.dataset.value);
            const balanceInUSD = balanceInCoin * coinValue;
            selectedWalletBalance = balanceInUSD;
            modalAvailableBalance.textContent = selectedWalletBalance.toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 });
            updateExpectedTotalReturn();
        }
        function updateExpectedTotalReturn() {
            const investedAmount = parseFloat(modalInvestedAmount.value);
            const chosenDurationValue = parseInt(modalUserChosenDurationValue.value);
            const chosenDurationUnit = modalUserChosenDurationUnit.value;
            let isValid = true;
            let errorMessage = '';
            if (isNaN(investedAmount) || investedAmount < currentPlanMinInvestment) {
                errorMessage = `Amount must be at least $${currentPlanMinInvestment.toLocaleString()}.`;
                isValid = false;
            } else if (investedAmount > currentPlanMaxInvestment) {
                errorMessage = `Amount cannot exceed $${currentPlanMaxInvestment.toLocaleString()}.`;
                isValid = false;
            }
            if (isValid && investedAmount > selectedWalletBalance) {
                errorMessage = `Insufficient balance in the selected wallet. Available: $${selectedWalletBalance.toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 })}`;
                isValid = false;
            }
            if (isNaN(chosenDurationValue) || chosenDurationValue < currentPlanMinDurationValue || chosenDurationValue > currentPlanMaxDurationValue) {
                errorMessage = `Duration must be between ${currentPlanMinDurationValue} and ${currentPlanMaxDurationValue} ${currentPlanAllowedDurationUnits[0] ?? 'days'}${currentPlanMaxDurationValue > 1 ? 's' : ''}.`;
                isValid = false;
            }
            if (!currentPlanAllowedDurationUnits.includes(chosenDurationUnit)) {
                errorMessage = `Selected duration unit (${chosenDurationUnit}) is not allowed for this plan.`;
                isValid = false;
            }
            modalInvestError.textContent = errorMessage;
            modalConfirmButton.disabled = !isValid;
            if (!isValid) {
                modalConfirmButton.classList.add('opacity-50', 'cursor-not-allowed');
            } else {
                modalConfirmButton.classList.remove('opacity-50', 'cursor-not-allowed');
            }
            let totalActualInvestmentDays = 0;
            if (isValid) {
                switch(chosenDurationUnit) {
                    case 'days': totalActualInvestmentDays = chosenDurationValue; break;
                    case 'weeks': totalActualInvestmentDays = chosenDurationValue * 7; break;
                    case 'months': totalActualInvestmentDays = chosenDurationValue * 30; break;
                    case 'years': totalActualInvestmentDays = chosenDurationValue * 365; break;
                    default: totalActualInvestmentDays = chosenDurationValue;
                }
            } else {
                totalActualInvestmentDays = 0;
            }
            const totalRoiPercentageCalculated = currentPlanDailyRoi * totalActualInvestmentDays;
            const expectedReturnAmount = isValid ? (investedAmount * (totalRoiPercentageCalculated / 100)) : 0;
            modalExpectedTotalReturn.textContent = '$' + expectedReturnAmount.toFixed(2);
        }
        sourceWalletSelect.addEventListener('change', updateSelectedWalletBalance);
        modalInvestedAmount.addEventListener('input', updateExpectedTotalReturn);
        modalUserChosenDurationValue.addEventListener('input', updateExpectedTotalReturn);
        modalUserChosenDurationUnit.addEventListener('change', updateExpectedTotalReturn);
        function ucfirst(str) {
            if (typeof str !== 'string' || str.length === 0) {
                return '';
            }
            return str.charAt(0).toUpperCase() + str.slice(1);
        }
        document.addEventListener('DOMContentLoaded', () => {
            if (sourceWalletSelect.options.length > 0) {
                updateSelectedWalletBalance();
            }
        });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\crypto-investment-app-v3.0\resources\views/investment.blade.php ENDPATH**/ ?>