<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">

        
        <h1 class="text-2xl font-bold text-white mb-6">Trade History & Positions</h1>

        
        <?php if(session('success')): ?>
            <div class="mb-4 p-4 bg-green-900 text-green-200 rounded-lg border border-green-700">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>
        <?php if(session('error')): ?>
            <div class="mb-4 p-4 bg-red-900 text-red-200 rounded-lg border border-red-700">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        
        <div class="bg-[#131319] rounded-lg shadow-lg border border-gray-700 mb-8 overflow-hidden">
            <div class="p-4 border-b border-gray-700 bg-gray-800/50 flex justify-between items-center">
                <h2 class="text-lg font-semibold text-white">Open Forex Positions</h2>
                <span class="text-xs text-gray-400">Net Holdings</span>
            </div>

            <div class="overflow-x-auto">
                <table class="w-full text-left text-sm text-gray-400">
                    <thead class="bg-gray-800 text-gray-200 uppercase text-xs">
                        <tr>
                            <th class="px-6 py-3">Pair</th>
                            <th class="px-6 py-3">Units Held</th>
                            <th class="px-6 py-3">Avg Entry</th>
                            <th class="px-6 py-3">Current Price</th>
                            <th class="px-6 py-3">Est. Value</th>
                            <th class="px-6 py-3 text-right">Action</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-700">
                        <?php $__empty_1 = true; $__currentLoopData = $openForexPositions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $currentPrice = $pos->pair->exchange_rate;
                                $value = $pos->balance * $currentPrice;
                                $pnl = ($currentPrice - $pos->avg_entry_price) * $pos->balance;
                                $isProfit = $pnl >= 0;
                            ?>
                            <tr class="hover:bg-gray-800/50 transition-colors">
                                <td class="px-6 py-4 font-bold text-white"><?php echo e($pos->pair->symbol); ?></td>
                                <td class="px-6 py-4"><?php echo e(number_format($pos->balance, 2)); ?></td>
                                <td class="px-6 py-4 text-gray-300"><?php echo e(number_format($pos->avg_entry_price, 4)); ?></td>
                                <td class="px-6 py-4 text-white"><?php echo e(number_format($currentPrice, 4)); ?></td>
                                <td class="px-6 py-4 font-mono">
                                    $<?php echo e(number_format($value, 2)); ?>

                                    <span class="text-xs block <?php echo e($isProfit ? 'text-green-400' : 'text-red-400'); ?>">
                                        <?php echo e($isProfit ? '+' : ''); ?><?php echo e(number_format($pnl, 2)); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-4 text-right">
                                    <form action="<?php echo e(route('trades.forex.close')); ?>" method="POST" onsubmit="return confirm('Are you sure you want to close this position? This will sell all units at current market price.');">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="wallet_id" value="<?php echo e($pos->id); ?>">
                                        <button type="submit" class="px-3 py-1 bg-red-600 hover:bg-red-700 text-white rounded text-xs font-semibold transition-colors">
                                            Close Position
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="px-6 py-8 text-center text-gray-500">No open forex positions.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        
        <div class="mb-4 border-b border-gray-700">
            <ul class="flex flex-wrap -mb-px text-sm font-medium text-center" id="history-tabs" role="tablist">
                <li class="mr-2" role="presentation">
                    <button class="inline-block p-4 text-blue-500 border-b-2 border-blue-500 rounded-t-lg hover:text-blue-400" id="forex-tab" type="button">Forex History</button>
                </li>
                <li class="mr-2" role="presentation">
                    <button class="inline-block p-4 text-gray-400 border-b-2 border-transparent rounded-t-lg hover:text-gray-300" id="stock-tab" type="button">Stock History</button>
                </li>
            </ul>
        </div>

        <div id="tab-content">
            
            <div class="hidden p-4 rounded-lg bg-[#131319] border border-gray-700" id="forex-history">

                
                <div class="mb-4">
                    <input type="text" id="forex-search" class="bg-gray-800 border border-gray-600 text-white text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 max-w-sm" placeholder="Search Symbol (e.g. EUR/USD)">
                </div>

                <div class="overflow-x-auto">
                    <table class="w-full text-left text-sm text-gray-400">
                        <thead class="bg-gray-800 text-gray-200 uppercase text-xs">
                            <tr>
                                <th class="px-6 py-3">Date</th>
                                <th class="px-6 py-3">Symbol</th>
                                <th class="px-6 py-3">Type</th>
                                <th class="px-6 py-3">Units</th>
                                <th class="px-6 py-3">Entry Price</th>
                                <th class="px-6 py-3">Leverage</th>
                                <th class="px-6 py-3">Margin/Cost</th>
                            </tr>
                        </thead>
                        <tbody id="forex-table-body" class="divide-y divide-gray-700">
                            <?php $__empty_1 = true; $__currentLoopData = $forexTrades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="hover:bg-gray-800/50">
                                    <td class="px-6 py-4"><?php echo e($trade->created_at->format('M d, Y H:i')); ?></td>
                                    <td class="px-6 py-4 font-bold text-white"><?php echo e($trade->pair->symbol); ?></td>
                                    <td class="px-6 py-4">
                                        <span class="px-2 py-1 rounded text-xs font-bold <?php echo e($trade->type === 'buy' ? 'bg-green-900 text-green-300' : 'bg-red-900 text-red-300'); ?>">
                                            <?php echo e(strtoupper($trade->type)); ?>

                                        </span>
                                    </td>
                                    <td class="px-6 py-4"><?php echo e(number_format($trade->quantity, 2)); ?></td>
                                    <td class="px-6 py-4"><?php echo e(number_format($trade->entry_price, 4)); ?></td>
                                    <td class="px-6 py-4">1:<?php echo e($trade->leverage_used); ?></td>
                                    <td class="px-6 py-4 text-white">$<?php echo e(number_format($trade->margin_amount, 2)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr><td colspan="7" class="px-6 py-4 text-center">No forex trade history.</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            
            <div class="hidden p-4 rounded-lg bg-[#131319] border border-gray-700" id="stock-history">
                 <div class="overflow-x-auto">
                    <table class="w-full text-left text-sm text-gray-400">
                        <thead class="bg-gray-800 text-gray-200 uppercase text-xs">
                            <tr>
                                <th class="px-6 py-3">Date</th>
                                <th class="px-6 py-3">Code</th>
                                <th class="px-6 py-3">Type</th>
                                <th class="px-6 py-3">Quantity</th>
                                <th class="px-6 py-3">Price</th>
                                <th class="px-6 py-3">Account</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-700">
                            <?php $__empty_1 = true; $__currentLoopData = $stockTrades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="hover:bg-gray-800/50">
                                    <td class="px-6 py-4"><?php echo e($trade->created_at->format('M d, Y H:i')); ?></td>
                                    <td class="px-6 py-4 font-bold text-white"><?php echo e($trade->stock->code); ?></td>
                                    <td class="px-6 py-4">
                                        <span class="px-2 py-1 rounded text-xs font-bold <?php echo e($trade->trade_action === 'buy' ? 'bg-green-900 text-green-300' : 'bg-red-900 text-red-300'); ?>">
                                            <?php echo e(strtoupper($trade->trade_action)); ?>

                                        </span>
                                    </td>
                                    <td class="px-6 py-4"><?php echo e(number_format($trade->shares_quantity ?? 0, 4)); ?></td>
                                    <td class="px-6 py-4">$<?php echo e(number_format($trade->price_per_share, 2)); ?></td>
                                    <td class="px-6 py-4 uppercase text-xs"><?php echo e($trade->account_type); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr><td colspan="6" class="px-6 py-4 text-center">No stock trade history.</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>

    <?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // --- TAB LOGIC ---
            const forexTab = document.getElementById('forex-tab');
            const stockTab = document.getElementById('stock-tab');
            const forexContent = document.getElementById('forex-history');
            const stockContent = document.getElementById('stock-history');

            function switchTab(active) {
                if (active === 'forex') {
                    forexContent.classList.remove('hidden');
                    stockContent.classList.add('hidden');

                    forexTab.classList.add('text-blue-500', 'border-blue-500');
                    forexTab.classList.remove('text-gray-400', 'border-transparent');

                    stockTab.classList.remove('text-blue-500', 'border-blue-500');
                    stockTab.classList.add('text-gray-400', 'border-transparent');
                } else {
                    stockContent.classList.remove('hidden');
                    forexContent.classList.add('hidden');

                    stockTab.classList.add('text-blue-500', 'border-blue-500');
                    stockTab.classList.remove('text-gray-400', 'border-transparent');

                    forexTab.classList.remove('text-blue-500', 'border-blue-500');
                    forexTab.classList.add('text-gray-400', 'border-transparent');
                }
            }

            forexTab.addEventListener('click', () => switchTab('forex'));
            stockTab.addEventListener('click', () => switchTab('stock'));

            // Initialize default tab
            switchTab('forex');

            // --- SEARCH FILTER ---
            const searchInput = document.getElementById('forex-search');
            if(searchInput) {
                searchInput.addEventListener('keyup', function() {
                    const value = this.value.toLowerCase();
                    const rows = document.querySelectorAll('#forex-table-body tr');

                    rows.forEach(row => {
                        const symbolCell = row.querySelector('td:nth-child(2)');
                        if(symbolCell) {
                            const symbol = symbolCell.textContent.toLowerCase();
                            if (symbol.includes(value)) {
                                row.style.display = '';
                            } else {
                                row.style.display = 'none';
                            }
                        }
                    });
                });
            }
        });
    </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\metaglobalbrokers-crypto-investment-app-v3.1\resources\views/trades/history.blade.php ENDPATH**/ ?>