<ul class="space-y-2 text-sm">
    
    <li>
        <a href="/admin/users" class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 <?php echo e(Request::is('admin/users*') ? 'bg-gray-700 text-white' : ''); ?>">
            <svg data-lucide="users" class="mr-3 w-5 h-5"></svg>
            Users
        </a>
    </li>

    
    <li>
        <a href="/admin/cards" class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 <?php echo e(Request::is('admin/cards') ? 'bg-gray-700 text-white' : ''); ?>">
            <svg data-lucide="credit-card" class="mr-3 w-5 h-5"></svg>
            Manage Cards
        </a>
    </li>

    <li>
        <a href="<?php echo e(route('admin.card.requests')); ?>" class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 <?php echo e(Request::is('admin/card-requests*') ? 'bg-gray-700 text-white' : ''); ?>">
            <svg data-lucide="inbox" class="mr-3 w-5 h-5"></svg>
            Card Requests
            <?php
                $pendingCards = \App\Models\CardActivationRequest::where('status', 'pending')->count();
            ?>
            <?php if($pendingCards > 0): ?>
                <span class="ml-auto bg-red-600 text-white text-[10px] font-bold px-2 py-0.5 rounded-full"><?php echo e($pendingCards); ?></span>
            <?php endif; ?>
        </a>
    </li>

    
    <li>
        <a href="<?php echo e(route('admin.kyc.index')); ?>" class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 <?php echo e(Request::is('admin/kyc*') ? 'bg-gray-700 text-white' : ''); ?>">
            <svg data-lucide="shield-check" class="mr-3 w-5 h-5"></svg>
            KYC Applications
            <?php
                $pendingKyc = \App\Models\User::where('kyc_status', 'pending')->count();
            ?>
            <?php if($pendingKyc > 0): ?>
                <span class="ml-auto bg-red-600 text-white text-[10px] font-bold px-2 py-0.5 rounded-full"><?php echo e($pendingKyc); ?></span>
            <?php endif; ?>
        </a>
    </li>

    
    <li>
        <a href="/admin/transactions" class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 <?php echo e(Request::is('admin/transactions*') ? 'bg-gray-700 text-white' : ''); ?>">
            <svg data-lucide="arrow-left-right" class="mr-3 w-5 h-5"></svg>
            Transactions
        </a>
    </li>

    
    <li>
        <a href="/admin/deposits" class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 <?php echo e(Request::is('admin/deposits') ? 'bg-gray-700 text-white' : ''); ?>">
            <svg data-lucide="download" class="mr-3 w-5 h-5"></svg>
            Deposits
        </a>
    </li>
    <li>
        <a href="/admin/withdrawals" class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 <?php echo e(Request::is('admin/withdrawals') ? 'bg-gray-700 text-white' : ''); ?>">
            <svg data-lucide="upload" class="mr-3 w-5 h-5"></svg>
            Withdrawals
        </a>
    </li>

    
    <li>
        <a href="<?php echo e(route('admin.personas.index')); ?>" class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 <?php echo e(Request::is('admin/personas*') ? 'bg-gray-700 text-white' : ''); ?>">
            <svg data-lucide="fingerprint" class="mr-3 w-5 h-5"></svg>
            Branding
        </a>
    </li>
    <li>
        <a href="/admin/coins" class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 <?php echo e(Request::is('admin/coins') ? 'bg-gray-700 text-white' : ''); ?>">
            <svg data-lucide="coins" class="mr-3 w-5 h-5"></svg>
            Manage Coins
        </a>
    </li>
    <li>
        <a href="/admin/referrals" class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 <?php echo e(Request::is('admin/referrals*') ? 'bg-gray-700 text-white' : ''); ?>">
            <svg data-lucide="share-2" class="mr-3 w-5 h-5"></svg>
            Referrals
        </a>
    </li>
    <li>
        <a href="/admin/settings" class="flex items-center px-4 py-3 text-gray-300 rounded-lg hover:bg-gray-700 hover:text-white transition-colors duration-200 <?php echo e(Request::is('admin/referrals*') ? 'bg-gray-700 text-white' : ''); ?>">
            <svg data-lucide="settings" class="mr-3 w-5 h-5"></svg>
            Settings
        </a>
    </li>
</ul>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\exodus-clone-laravel\resources\views/components/admin-navigation.blade.php ENDPATH**/ ?>