<?php
    // Fetch user balances for JS validation (Handles case where wallet might not exist yet)
    $jsBalances = [];
    if(auth()->check() && auth()->user()->wallet) {
        $jsBalances = auth()->user()->wallet->walletCoins()
            ->with('coin')
            ->get()
            ->mapWithKeys(function($wc) {
                // Returns format: ['BTC' => 0.045, 'ETH' => 1.5]
                return [$wc->coin->code => (float)$wc->balance];
            });
    }
?>

<div id="tab-content-wallet" class="hidden animate-fade-in">
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">

        
        <div class="lg:col-span-1 space-y-6">

            
            <div class="grid grid-cols-2 gap-3">
                <button onclick="document.getElementById('crypto-select').focus()" class="py-3 px-4 bg-indigo-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-indigo-500/20 hover:bg-indigo-700 transition-all flex items-center justify-center gap-2">
                    <i data-lucide="send" class="w-4 h-4"></i> Send
                </button>
                <button onclick="openWithdrawModal()" class="py-3 px-4 bg-white border border-gray-200 text-slate-700 rounded-xl text-sm font-bold hover:bg-gray-50 transition-all flex items-center justify-center gap-2">
                    <i data-lucide="banknote" class="w-4 h-4"></i> Withdraw
                </button>
            </div>

            <h3 class="font-bold text-slate-800 text-lg">Your Assets</h3>

            
            <div class="space-y-3">
                <?php
                    // 1. Fetch Coins from DB to get the dynamic 'value'
                    // We key by 'code' (BTC, ETH) for easy lookup
                    $dbCoins = \App\Models\Coin::whereIn('code', ['BTC', 'ETH', 'USDT'])->get()->keyBy('code');

                    // 2. Define Display Attributes (Logos, Badges, etc.)
                    $assets = [
                        [
                            'name' => 'Bitcoin',
                            'symbol' => 'BTC',
                            'logo' => 'https://cryptologos.cc/logos/bitcoin-btc-logo.png',
                            'decimals' => 8,
                            'badge' => 'bg-orange-50 text-orange-700 border-orange-100',
                        ],
                        [
                            'name' => 'Ethereum',
                            'symbol' => 'ETH',
                            'logo' => 'https://cryptologos.cc/logos/ethereum-eth-logo.png',
                            'decimals' => 8,
                            'badge' => 'bg-purple-50 text-purple-700 border-purple-100',
                        ],
                        [
                            'name' => 'Tether',
                            'symbol' => 'USDT',
                            'logo' => 'https://cryptologos.cc/logos/tether-usdt-logo.png',
                            'decimals' => 2,
                            'badge' => 'bg-green-50 text-green-700 border-green-100',
                        ],
                    ];
                ?>

                <?php $__currentLoopData = $assets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asset): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $symbol = $asset['symbol'];

                        // Get Balance from the JS array passed earlier
                        $balance = $jsBalances[$symbol] ?? 0;

                        // Get Price from DB Model
                        $coinModel = $dbCoins->get($symbol);
                        $price = $coinModel ? $coinModel->value : 0; // Use 'value' from Coin model

                        // Calculate Fiat Value
                        $fiatValue = $balance * $price;
                    ?>

                    <div
                        onclick="selectCoin('<?php echo e($symbol); ?>')"
                        class="bg-white rounded-2xl border border-gray-100
                            hover:border-indigo-200 hover:shadow-md
                            transition-all cursor-pointer p-4">

                        <div class="flex items-start gap-4">

                            
                            <div class="w-10 h-10 flex-shrink-0">
                                <img src="<?php echo e($asset['logo']); ?>"
                                    alt="<?php echo e($asset['name']); ?>"
                                    class="w-full h-full object-contain">
                            </div>

                            
                            <div class="flex-1 min-w-0 space-y-1">

                                
                                <div class="flex items-center gap-2 flex-wrap">
                                    <h4 class="font-semibold text-slate-900 truncate">
                                        <?php echo e($asset['name']); ?>

                                    </h4>

                                    <span class="px-2 py-0.5 text-xs font-semibold rounded-md border <?php echo e($asset['badge']); ?>">
                                        <?php echo e($symbol); ?>

                                    </span>
                                </div>

                                
                                <p class="text-xs text-slate-500 uppercase tracking-wide">
                                    Available
                                </p>

                                
                                <p
                                    title="<?php echo e(number_format($balance, $asset['decimals'])); ?>"
                                    class="font-mono font-bold text-slate-900 tabular-nums whitespace-nowrap overflow-hidden text-ellipsis leading-tight">
                                    <?php echo e(number_format($balance, $asset['decimals'])); ?>

                                </p>

                                
                                <p class="text-xs text-slate-400 font-medium">
                                    ≈ $<?php echo e(number_format($fiatValue, 2)); ?>

                                </p>

                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        
        <div class="lg:col-span-2">
            <div class="bg-white rounded-2xl border border-gray-100 shadow-[0_2px_15px_rgb(0,0,0,0.04)] p-8 h-full">
                <h3 class="font-bold text-slate-800 text-xl mb-6 flex items-center gap-2">
                    <div class="w-8 h-8 rounded-full bg-indigo-50 flex items-center justify-center">
                        <i data-lucide="send" class="w-4 h-4 text-indigo-600"></i>
                    </div>
                    Send Crypto
                </h3>

                <form id="sendCryptoForm" onsubmit="initiateSendTransaction(event)">
                    <?php echo csrf_field(); ?>
                    <div class="space-y-6">

                        
                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">Select Asset</label>
                            <div class="relative">
                                <select id="crypto-select" name="asset" class="block w-full rounded-xl border-gray-200 bg-gray-50 p-3.5 pl-10 text-sm text-slate-900 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 appearance-none font-medium transition-all">
                                    <option value="BTC">Bitcoin (BTC)</option>
                                    <option value="ETH">Ethereum (ETH)</option>
                                    <option value="USDT">Tether (USDT)</option>
                                </select>
                                <i data-lucide="coins" class="w-4 h-4 text-gray-400 absolute left-3.5 top-4"></i>
                                <i data-lucide="chevron-down" class="w-4 h-4 text-gray-400 absolute right-3.5 top-4 pointer-events-none"></i>
                            </div>
                        </div>

                        
                        <div>
                            <label class="block text-sm font-bold text-slate-700 mb-2">Recipient Address</label>
                            <div class="relative">
                                <input type="text" name="address" required placeholder="Paste wallet address here"
                                       class="block w-full rounded-xl border-gray-200 bg-gray-50 p-3.5 pl-10 text-sm text-slate-900 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 placeholder:text-gray-400 font-mono transition-all">
                                <i data-lucide="qr-code" class="w-4 h-4 text-gray-400 absolute left-3.5 top-4"></i>
                            </div>
                        </div>

                        
                        <div>
                            <div class="flex justify-between mb-2">
                                <label class="block text-sm font-bold text-slate-700">Amount</label>
                                
                                <span class="text-xs text-indigo-600 font-bold cursor-pointer hover:underline" onclick="setMaxAmount()">
                                    Max: <span id="max-balance-display">0.00</span>
                                </span>
                            </div>
                            <div class="relative">
                                
                                <input type="number" step="any" name="amount" id="amount-input" required placeholder="0.00"
                                       class="block w-full rounded-xl border-gray-200 bg-gray-50 p-3.5 pl-10 text-sm text-slate-900 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 placeholder:text-gray-400 font-bold transition-all">
                                <i data-lucide="calculator" class="w-4 h-4 text-gray-400 absolute left-3.5 top-4"></i>
                                <span class="absolute right-4 top-3.5 text-xs font-bold text-gray-400 uppercase" id="currency-label">BTC</span>
                            </div>
                            
                            <p id="amount-error-msg" class="hidden text-xs text-red-500 font-bold mt-2 flex items-center gap-1 animate-fade-in">
                                <i data-lucide="alert-circle" class="w-3 h-3"></i> Insufficient balance for this transaction.
                            </p>
                        </div>

                        
                        <div class="bg-indigo-50 rounded-xl p-4 flex justify-between items-center border border-indigo-100">
                            <div class="flex items-center gap-2">
                                <i data-lucide="fuel" class="w-4 h-4 text-indigo-600"></i>
                                <span class="text-sm font-medium text-indigo-900">Network Fee (Est.)</span>
                            </div>
                            <span class="text-sm font-bold text-indigo-700" id="network-fee">0.00045 BTC</span>
                        </div>

                        <div class="pt-2">
                            <button type="submit" id="btn-send-submit" class="w-full py-4 bg-indigo-600 text-white font-bold rounded-xl shadow-lg shadow-indigo-500/30 hover:bg-indigo-700 transition-all flex items-center justify-center gap-2">
                                Next <i data-lucide="arrow-right" class="w-4 h-4"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>




<div id="withdrawModal" class="fixed inset-0 z-[9999] hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
    <div class="fixed inset-0 bg-slate-900/80 backdrop-blur-sm transition-opacity cursor-pointer" onclick="closeWithdrawModal()"></div>
    <div class="fixed inset-0 z-10 overflow-y-auto pointer-events-none">
        <div class="flex min-h-full items-center justify-center p-4 text-center">
            <div class="relative transform overflow-hidden rounded-2xl bg-white text-left shadow-2xl transition-all sm:w-full sm:max-w-md border border-gray-100 scale-95 opacity-0 duration-300 ease-out pointer-events-auto" id="withdrawModalContent">
                
                <div id="withdrawStep1" class="p-8">
                    <div class="text-center mb-6">
                        <div class="w-16 h-16 bg-blue-50 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i data-lucide="shield-alert" class="w-8 h-8 text-blue-600"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-slate-900">Security Check</h3>
                        <p class="text-sm text-slate-500 mt-2">Please confirm you are human to proceed.</p>
                    </div>
                    <div class="bg-gray-50 border border-gray-200 rounded-xl p-4 flex items-center gap-4 mb-6 cursor-pointer hover:bg-gray-100 transition-colors" onclick="document.getElementById('robotCheck').click()">
                        <input type="checkbox" id="robotCheck" class="w-6 h-6 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500 cursor-pointer">
                        <label for="robotCheck" class="text-sm font-semibold text-slate-700 cursor-pointer select-none">I am not a robot</label>
                        <img src="https://www.gstatic.com/recaptcha/api2/logo_48.png" class="w-8 h-8 ml-auto opacity-50" alt="captcha">
                    </div>
                    <button onclick="goToWithdrawStep2()" class="w-full py-3 bg-indigo-600 text-white font-bold rounded-xl shadow-lg shadow-indigo-500/30 hover:bg-indigo-700 transition-all flex items-center justify-center gap-2">Verify & Continue</button>
                </div>
                
                <div id="withdrawStep2" class="hidden p-8">
                    <div class="text-center mb-6">
                        <img src="<?php echo e(asset('images/moonpay-logo.svg')); ?>" class="h-8 mx-auto mb-4" alt="MoonPay">
                        <h3 class="text-xl font-bold text-slate-900">Connect MoonPay</h3>
                        <p class="text-sm text-slate-500 mt-2">Enter your email to access MoonPay withdrawals.</p>
                    </div>
                    <div class="space-y-4">
                        <input type="email" id="moonpayEmail" placeholder="name@example.com" class="block w-full rounded-xl border-gray-200 bg-white p-3.5 text-sm text-slate-900 focus:border-indigo-500 focus:ring-indigo-500 shadow-sm">
                        <button onclick="submitWithdraw()" class="w-full py-3 bg-indigo-600 text-white font-bold rounded-xl shadow-lg shadow-indigo-500/30 hover:bg-indigo-700 transition-all flex items-center justify-center gap-2">Continue <i data-lucide="external-link" class="w-4 h-4"></i></button>
                    </div>
                    <button onclick="closeWithdrawModal()" class="w-full mt-4 text-sm text-slate-400 font-medium hover:text-slate-600">Cancel</button>
                </div>
            </div>
        </div>
    </div>
</div>




<div id="txModal" class="fixed inset-0 z-[9999] hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
    <div class="fixed inset-0 bg-slate-900/80 backdrop-blur-sm transition-opacity" onclick="closeTxModal()"></div>
    <div class="fixed inset-0 z-10 overflow-y-auto pointer-events-none">
        <div class="flex min-h-full items-center justify-center p-4 text-center">

            
            <div class="relative transform overflow-hidden rounded-2xl bg-white text-left shadow-2xl transition-all sm:w-full sm:max-w-md border border-gray-100 scale-95 opacity-0 duration-300 ease-out pointer-events-auto" id="txModalContent">

                
                <div id="state-error" class="p-6 pt-8 text-center hidden">
                    <div class="relative mx-auto mb-6 w-20 h-20">
                        <div class="absolute inset-0 bg-red-100 rounded-full animate-ping opacity-75"></div>
                        <div class="relative bg-red-50 rounded-full w-20 h-20 flex items-center justify-center border-2 border-red-100">
                            <i data-lucide="alert-octagon" class="w-10 h-10 text-red-500"></i>
                        </div>
                    </div>
                    <h3 class="text-2xl font-bold text-slate-900 mb-2">Transaction Interrupted</h3>
                    <p class="text-slate-500 text-sm font-medium">Error Code: #BLK-AUTH-92</p>
                    <div class="mt-6 bg-red-50 border border-red-100 rounded-xl p-4 text-left">
                        <div class="flex gap-3">
                            <i data-lucide="shield-alert" class="w-5 h-5 text-red-500 flex-shrink-0 mt-0.5"></i>
                            <p class="text-sm text-red-700 font-medium leading-relaxed" id="error-message-text">
                                
                            </p>
                        </div>
                    </div>
                    <button onclick="closeTxModal()" class="w-full mt-6 py-3 bg-white border border-gray-300 text-slate-700 font-bold rounded-xl hover:bg-gray-50 transition-all">Dismiss</button>
                </div>

                
                <div id="state-success" class="p-8 text-center hidden">
                    <div class="w-20 h-20 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <i data-lucide="check-circle-2" class="w-10 h-10 text-green-600"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-slate-900">Transaction Successful</h3>
                    <p class="text-slate-500 text-sm mt-2">Your transfer request has been submitted.</p>

                    <div class="mt-6 bg-slate-50 rounded-xl p-4 border border-slate-100 text-left space-y-3">
                        <div class="flex justify-between items-center pb-3 border-b border-slate-200">
                            <span class="text-sm text-slate-500">Amount Sent</span>
                            <span class="text-sm font-bold text-slate-900">
                                <span id="success-amount">0.00</span>
                                <span id="success-asset">BTC</span>
                            </span>
                        </div>
                        <div class="flex justify-between items-start pt-1">
                            <span class="text-sm text-slate-500 flex-shrink-0">Destination</span>
                            <span class="text-xs font-mono font-medium text-slate-700 text-right break-all ml-4" id="success-address">
                                
                            </span>
                        </div>
                    </div>

                    <div class="mt-4 flex items-center gap-2 justify-center text-blue-600 bg-blue-50 py-2 rounded-lg">
                        <i data-lucide="clock" class="w-4 h-4"></i>
                        <span class="text-xs font-bold">The address will be funded shortly.</span>
                    </div>

                    <button onclick="closeTxModal(); window.location.reload();" class="w-full mt-6 py-3 bg-indigo-600 text-white font-bold rounded-xl shadow-lg shadow-indigo-500/30 hover:bg-indigo-700 transition-all">
                        Done
                    </button>
                </div>

            </div>
        </div>
    </div>
</div>




<script>
    // --- 1. SETUP BALANCES ---
    // Injected from the PHP block at the top
    const userBalances = <?php echo json_encode($jsBalances, 15, 512) ?>;

    // Current selection tracking
    let currentAsset = 'BTC';
    let currentBalance = 0;

    // --- 2. INITIALIZATION ---
    document.addEventListener('DOMContentLoaded', () => {
        // Initialize with default selected option (usually BTC)
        const initialCoin = document.getElementById('crypto-select').value;
        selectCoin(initialCoin);

        // Attach listener for real-time validation
        const amountInput = document.getElementById('amount-input');
        if(amountInput) {
            amountInput.addEventListener('input', validateAmount);
        }
    });

    // --- 3. ASSET SELECTION ---
    function selectCoin(code) {
        currentAsset = code;
        currentBalance = userBalances[code] || 0.00; // Default to 0 if not found

        // Update Dropdown UI
        const selectEl = document.getElementById('crypto-select');
        if(selectEl.value !== code) selectEl.value = code;

        // Update Labels (Max Balance and Currency Code)
        document.getElementById('currency-label').innerText = code;

        const maxDisplay = document.getElementById('max-balance-display');
        if(maxDisplay) maxDisplay.innerText = `${currentBalance} ${code}`; // Raw number for now, can format if needed

        updateFeeDisplay(code);

        // Re-validate if user has already typed an amount
        const amountInput = document.getElementById('amount-input');
        if(amountInput.value) validateAmount();
    }

    // --- 4. MAX BUTTON LOGIC ---
    function setMaxAmount() {
        const amountInput = document.getElementById('amount-input');
        // Simple Set: Set value to current balance
        amountInput.value = currentBalance;
        validateAmount(); // Trigger validation styles
    }

    // --- 5. VALIDATION LOGIC ---
    function validateAmount() {
        const amountInput = document.getElementById('amount-input');
        const submitBtn = document.getElementById('btn-send-submit');
        const errorMsg = document.getElementById('amount-error-msg');

        const amount = parseFloat(amountInput.value);

        // Check: Is Amount > Balance?
        if (amount > currentBalance) {
            // ERROR STATE
            amountInput.classList.add('border-red-500', 'focus:border-red-500', 'focus:ring-red-500', 'text-red-600');
            amountInput.classList.remove('border-gray-200', 'focus:border-indigo-500', 'focus:ring-indigo-500', 'text-slate-900');

            submitBtn.disabled = true;
            submitBtn.classList.add('opacity-50', 'cursor-not-allowed');

            if(errorMsg) errorMsg.classList.remove('hidden');
        } else {
            // NORMAL STATE
            amountInput.classList.remove('border-red-500', 'focus:border-red-500', 'focus:ring-red-500', 'text-red-600');
            amountInput.classList.add('border-gray-200', 'focus:border-indigo-500', 'focus:ring-indigo-500', 'text-slate-900');

            submitBtn.disabled = false;
            submitBtn.classList.remove('opacity-50', 'cursor-not-allowed');

            if(errorMsg) errorMsg.classList.add('hidden');
        }
    }

// --- 6. SEND TRANSACTION (UPDATED) ---
    async function initiateSendTransaction(e) {
        e.preventDefault();

        const amountInput = document.getElementById('amount-input');
        const amount = parseFloat(amountInput.value);

        if (amount > currentBalance) {
            validateAmount();
            return;
        }

        const btn = document.getElementById('btn-send-submit');
        const form = document.getElementById('sendCryptoForm');
        const originalText = btn.innerHTML;

        btn.innerHTML = '<i data-lucide="loader-2" class="w-5 h-5 animate-spin"></i> Processing...';
        btn.disabled = true;
        lucide.createIcons();

        try {
            const response = await fetch('/user/crypto/send', {
                method: 'POST',
                body: new FormData(form),
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            });

            const data = await response.json();

            if (data.status === 'blocked') {
                openTxModal('error', data.message);
            } else if (data.status === 'success') {
                // Pass details to the success modal
                openTxModal('success', null, data.details);
            } else {
                openTxModal('error', 'Unexpected server response.');
            }

        } catch (error) {
            console.error('Error:', error);
            openTxModal('error', 'Network Error: Unable to complete request.');
        } finally {
            btn.innerHTML = originalText;
            btn.disabled = false;
            lucide.createIcons();
        }
    }

    // --- 7. HELPERS (Dropdown Listener & Fees) ---
    document.getElementById('crypto-select').addEventListener('change', function() { selectCoin(this.value); });

    function updateFeeDisplay(code) {
        let fee = (code === 'BTC') ? '0.00045 BTC' : (code === 'ETH' ? '0.0021 ETH' : '1.00 USDT');
        document.getElementById('network-fee').innerText = fee;
    }

    // --- MODAL LOGIC (UPDATED) ---
    function openTxModal(state, message = '', details = null) {
        const modal = document.getElementById('txModal');
        const content = document.getElementById('txModalContent');

        document.getElementById('state-error').classList.add('hidden');
        document.getElementById('state-success').classList.add('hidden');

        if (state === 'error') {
            document.getElementById('state-error').classList.remove('hidden');
            document.getElementById('error-message-text').innerText = message;
        }
        else if (state === 'success' && details) {
            document.getElementById('state-success').classList.remove('hidden');

            // Populate Details
            document.getElementById('success-amount').innerText = details.amount;
            document.getElementById('success-asset').innerText = details.asset;
            document.getElementById('success-address').innerText = details.address;
        }

        modal.classList.remove('hidden');
        setTimeout(() => {
            content.classList.remove('scale-95', 'opacity-0');
            content.classList.add('scale-100', 'opacity-100');
        }, 10);
        lucide.createIcons();
    }

    function closeTxModal() {
        const modal = document.getElementById('txModal');
        const content = document.getElementById('txModalContent');
        content.classList.remove('scale-100', 'opacity-100');
        content.classList.add('scale-95', 'opacity-0');
        setTimeout(() => { modal.classList.add('hidden'); }, 300);
    }

    const moonpayLink = "<?php echo e(env('MOONPAY_LINK')); ?>";
    function openWithdrawModal() {
        const modal = document.getElementById('withdrawModal');
        const content = document.getElementById('withdrawModalContent');
        document.getElementById('withdrawStep1').classList.remove('hidden');
        document.getElementById('withdrawStep2').classList.add('hidden');
        document.getElementById('robotCheck').checked = false;
        document.getElementById('moonpayEmail').value = '';
        modal.classList.remove('hidden');
        setTimeout(() => { content.classList.remove('scale-95', 'opacity-0'); content.classList.add('scale-100', 'opacity-100'); }, 10);
    }
    function closeWithdrawModal() {
        const modal = document.getElementById('withdrawModal');
        const content = document.getElementById('withdrawModalContent');
        content.classList.remove('scale-100', 'opacity-100');
        content.classList.add('scale-95', 'opacity-0');
        setTimeout(() => { modal.classList.add('hidden'); }, 300);
    }
    function goToWithdrawStep2() {
        if (!document.getElementById('robotCheck').checked) { alert('Please confirm you are not a robot.'); return; }
        document.getElementById('withdrawStep1').classList.add('opacity-0');
        setTimeout(() => {
            document.getElementById('withdrawStep1').classList.add('hidden');
            document.getElementById('withdrawStep1').classList.remove('opacity-0');
            document.getElementById('withdrawStep2').classList.remove('hidden');
            document.getElementById('withdrawStep2').classList.add('animate-fade-in');
        }, 200);
    }
    function submitWithdraw() {
        const email = document.getElementById('moonpayEmail').value;
        if (!email || !email.includes('@')) { alert('Please enter a valid email address.'); return; }
        const separator = moonpayLink.includes('?') ? '&' : '?';
        window.location.href = `${moonpayLink}${separator}email=${encodeURIComponent(email)}`;
    }
</script>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\exodus-clone-laravel\resources\views/components/dashboard-wallet-tab.blade.php ENDPATH**/ ?>