<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="max-w-[1600px] mx-auto space-y-8">

        
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
            <div>
                <h1 class="text-2xl font-bold text-slate-900 flex items-center gap-3">
                    <div class="w-10 h-10 rounded-full bg-indigo-50 flex items-center justify-center text-indigo-600">
                        <i data-lucide="download" class="w-5 h-5"></i>
                    </div>
                    Deposit Funds
                </h1>
                <p class="text-sm text-slate-500 mt-1 ml-13">Add funds to your wallet securely via crypto or bank transfer.</p>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-12 gap-8">

            
            <div class="lg:col-span-8 space-y-8">

                
                <div class="bg-indigo-50 border border-indigo-100 rounded-2xl p-6 relative overflow-hidden">
                    <div class="absolute top-0 right-0 w-32 h-32 bg-indigo-100 rounded-full blur-3xl -mr-10 -mt-10"></div>
                    <h4 class="text-lg font-bold text-indigo-900 mb-2 relative z-10">Payment Guide</h4>
                    <p class="text-indigo-700 text-sm leading-relaxed relative z-10">
                        Make payment to the account details below using the payment ID:
                        <span class="font-mono font-bold bg-white px-2 py-0.5 rounded text-indigo-600 border border-indigo-200"><?php echo e($transactionId); ?></span>
                        as your description. Then click <span class="font-bold">"I have made Payment"</span> for verification.
                    </p>
                </div>

                
                <?php if($errors->any()): ?>
                    <div class="bg-red-50 border border-red-100 rounded-xl p-4">
                        <div class="flex">
                            <i data-lucide="alert-circle" class="h-5 w-5 text-red-400"></i>
                            <div class="ml-3">
                                <h3 class="text-sm font-medium text-red-800">Please correct the following errors:</h3>
                                <ul class="mt-2 text-sm text-red-700 list-disc list-inside">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                
                <div class="bg-white rounded-2xl border border-gray-100 shadow-[0_2px_15px_rgb(0,0,0,0.04)] overflow-hidden">
                    <div class="p-8">
                        <form action="" method="POST" class="space-y-6">
                            <?php echo csrf_field(); ?>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                
                                <div class="col-span-1 md:col-span-2">
                                    <label for="wallet_option" class="block text-sm font-bold text-slate-700 mb-2">Select Wallet</label>
                                    <div class="relative">
                                        <select id="wallet_option" name="wallet_coin_id" class="block w-full rounded-xl border-gray-200 bg-gray-50 p-3.5 text-sm text-slate-900 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 transition-all appearance-none cursor-pointer">
                                            <?php $__currentLoopData = $payment_options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($option->id); ?>" data-value="<?php echo e($option->value); ?>" data-account-details="<?php echo e($option->account_details); ?>" data-name="<?php echo e($option->name); ?>" data-code="<?php echo e($option->code); ?>" <?php if($option->code === 'USD'): ?> selected <?php endif; ?>>
                                                    <?php echo e($option->name); ?> (<?php echo e($option->code); ?>)
                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <i data-lucide="chevron-down" class="w-5 h-5 text-gray-400 absolute right-3.5 top-3.5 pointer-events-none"></i>
                                    </div>
                                </div>

                                
                                <div class="col-span-1 md:col-span-2">
                                    <label for="payment_option" class="block text-sm font-bold text-slate-700 mb-2">Payment Method</label>
                                    <div class="relative">
                                        <select id="payment_option" name="payment_option_id" class="block w-full rounded-xl border-gray-200 bg-gray-50 p-3.5 text-sm text-slate-900 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 transition-all appearance-none cursor-pointer">
                                            <?php $__currentLoopData = $payment_options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($option->id); ?>" data-value="<?php echo e($option->value); ?>" data-account-details="<?php echo e($option->account_details); ?>" data-name="<?php echo e($option->name); ?>" data-code="<?php echo e($option->code); ?>" <?php if($option->code === 'BTC'): ?> selected <?php endif; ?>>
                                                    <?php echo e($option->name); ?> (<?php echo e($option->code); ?>)
                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <i data-lucide="chevron-down" class="w-5 h-5 text-gray-400 absolute right-3.5 top-3.5 pointer-events-none"></i>
                                    </div>
                                </div>

                                
                                <div class="col-span-1 md:col-span-2">
                                    <label class="block text-sm font-bold text-slate-700 mb-2">Input Mode</label>
                                    <div class="flex bg-gray-100 p-1 rounded-xl">
                                        <button type="button" id="usd-toggle" class="flex-1 py-2.5 rounded-lg text-sm font-bold transition-all shadow-sm bg-white text-indigo-600">
                                            Enter USD Amount
                                        </button>
                                        <button type="button" id="wallet-toggle" class="flex-1 py-2.5 rounded-lg text-sm font-medium text-slate-500 hover:text-slate-700 transition-all">
                                            Enter <span id="wallet-toggle-label">USD</span> Amount
                                        </button>
                                    </div>
                                </div>

                                
                                <div class="col-span-1 md:col-span-2">
                                    <label for="amount_input" class="block text-sm font-bold text-slate-700 mb-2">
                                        <span id="amount-input-label">Enter USD Amount</span>
                                    </label>
                                    <div class="relative">
                                        <input type="number" step="any" id="amount_input" class="block w-full rounded-xl border-gray-200 bg-white p-4 text-lg font-bold text-slate-900 placeholder:text-gray-300 focus:border-indigo-500 focus:ring-indigo-500 shadow-sm" placeholder="0.00" required />
                                    </div>
                                </div>

                                
                                <div class="col-span-1 md:col-span-2">
                                    <div class="bg-gray-50 rounded-xl p-6 border border-gray-100">
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                            <div>
                                                <p class="text-xs font-bold text-slate-400 uppercase tracking-wider mb-1">Wallet Credited</p>
                                                <div id="wallet-amount-display" class="text-2xl font-bold text-slate-900">0 USD</div>
                                            </div>
                                            <div>
                                                <p class="text-xs font-bold text-slate-400 uppercase tracking-wider mb-1">Amount to Pay</p>
                                                <div id="payment-amount-display" class="text-2xl font-bold text-indigo-600">0 BTC</div>
                                            </div>
                                        </div>
                                        <div class="mt-4 pt-4 border-t border-gray-200">
                                            <p id="usd-equivalent-display" class="text-sm font-medium text-slate-500 text-center">USD Equivalent: $0.00</p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            
                            <input type="hidden" id="transaction_id" name="transaction_id" value="<?php echo e($transactionId); ?>" required />
                            <input type="hidden" id="type" name="type" value="deposit" required />
                            <input type="hidden" id="submitted_amount" name="amount_coin" />
                            <input type="hidden" id="submitted_payment_option_id" name="payment_option_id" />
                            <input type="hidden" id="submitted_usd_amount" name="amount" />

                            <div class="pt-2">
                                <button type="submit" class="w-full py-4 bg-indigo-600 text-white font-bold rounded-xl shadow-lg shadow-indigo-500/30 hover:bg-indigo-700 transition-all flex items-center justify-center gap-2">
                                    <i data-lucide="check-circle" class="w-5 h-5"></i>
                                    I Have Made Payment
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            
            <div class="lg:col-span-4 space-y-8">

                
                <div class="bg-white rounded-2xl border border-gray-100 shadow-[0_2px_15px_rgb(0,0,0,0.04)] overflow-hidden sticky top-8">
                    <div class="bg-slate-900 p-6 text-center">
                        <p class="text-slate-400 text-sm font-medium mb-1">Send payment to</p>
                        <h3 id="account-code-display" class="text-2xl font-bold text-white">BTC</h3>
                    </div>

                    <div class="p-6">
                        <div class="bg-gray-50 rounded-xl p-4 border border-gray-100 text-center break-all">
                            <?php
                                $defaultPaymentOption = $payment_options->firstWhere('code', 'BTC');
                                $defaultAccountDetails = $defaultPaymentOption ? $defaultPaymentOption->account_details : 'No account details available.';
                            ?>
                            <p id="account-details" class="text-slate-600 font-mono text-sm leading-relaxed">
                                <?php echo e($defaultAccountDetails); ?>

                            </p>
                        </div>

                        
                        <button onclick="copyAddress()" class="w-full mt-4 py-2.5 bg-white border border-gray-200 text-slate-700 font-bold rounded-xl hover:bg-gray-50 transition-all flex items-center justify-center gap-2 text-sm shadow-sm">
                            <i data-lucide="copy" class="w-4 h-4"></i> Copy Address
                        </button>

                        <button type="button" id="request_bank_details_btn" class="hidden w-full mt-4 py-2.5 bg-indigo-600 text-white font-bold rounded-xl hover:bg-indigo-700 transition-all text-sm shadow-sm">
                            Request Account Details
                        </button>

                        <div class="mt-6 text-center">
                            <div class="inline-flex items-center justify-center w-12 h-12 rounded-full bg-orange-100 text-orange-600 mb-3">
                                <i data-lucide="alert-triangle" class="w-6 h-6"></i>
                            </div>
                            <p class="text-xs text-slate-500 leading-relaxed">
                                Please ensure you send the exact amount to the address above. Sending any other currency to this address may result in permanent loss of funds.
                            </p>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    
    <?php if(session('success')): ?>
    <div id="success-alert-modal" class="fixed inset-0 z-[999]" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="fixed inset-0 bg-slate-900/60 backdrop-blur-sm transition-opacity"></div>
        <div class="fixed inset-0 z-10 overflow-y-auto">
            <div class="flex min-h-full items-center justify-center p-4 text-center sm:p-0">
                <div class="relative transform overflow-hidden rounded-2xl bg-white text-left shadow-2xl transition-all sm:my-8 sm:w-full sm:max-w-md border border-gray-100">
                    <div class="p-8 text-center">
                        <div class="mx-auto flex h-16 w-16 items-center justify-center rounded-full bg-emerald-100 mb-6">
                            <i data-lucide="check" class="h-8 w-8 text-emerald-600"></i>
                        </div>

                        <?php if(session('success') === 'Deposit request made successfully!'): ?>
                            <h3 class="text-2xl font-bold text-slate-900 mb-2">Request Sent!</h3>
                            <p class="text-slate-500 text-sm mb-6">
                                Transaction ID: <span class="font-mono font-bold text-slate-900 bg-gray-100 px-2 py-0.5 rounded"><?php echo e(session('transaction_id')); ?></span><br><br>
                                You will receive an email shortly with the account details for the bank transfer.
                            </p>
                        <?php else: ?>
                            <h3 class="text-2xl font-bold text-slate-900 mb-2">Deposit Logged!</h3>
                            <p class="text-slate-500 text-sm mb-6">
                                Transaction ID: <span class="font-mono font-bold text-slate-900 bg-gray-100 px-2 py-0.5 rounded"><?php echo e(session('transaction_id')); ?></span><br><br>
                                Your deposit has been logged and will be credited once confirmed by the network.
                            </p>
                        <?php endif; ?>

                        <div class="grid grid-cols-2 gap-4">
                            <button type="button" onclick="document.getElementById('success-alert-modal').remove()" class="w-full py-2.5 bg-white border border-gray-200 text-slate-700 font-bold rounded-xl hover:bg-gray-50 transition-all text-sm">
                                Close
                            </button>
                            <a href="/dashboard" class="w-full py-2.5 bg-indigo-600 text-white font-bold rounded-xl hover:bg-indigo-700 transition-all text-sm flex items-center justify-center">
                                Go to Wallet
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php $__env->startPush('scripts'); ?>
    <script>
        // DOM Elements
        const elements = {
            walletSelect: document.getElementById('wallet_option'),
            paymentSelect: document.getElementById('payment_option'),
            accountDetails: document.getElementById('account-details'),
            accountCode: document.getElementById('account-code-display'),
            requestBtn: document.getElementById('request_bank_details_btn'),
            inputs: {
                amount: document.getElementById('amount_input'),
                submittedAmount: document.getElementById('submitted_amount'),
                paymentOptionId: document.getElementById('submitted_payment_option_id'),
                usdAmount: document.getElementById('submitted_usd_amount'),
            },
            displays: {
                wallet: document.getElementById('wallet-amount-display'),
                payment: document.getElementById('payment-amount-display'),
                usd: document.getElementById('usd-equivalent-display'),
            },
            toggles: {
                usd: document.getElementById('usd-toggle'),
                wallet: document.getElementById('wallet-toggle'),
                walletLabel: document.getElementById('wallet-toggle-label'),
            },
            labels: {
                amountInput: document.getElementById('amount-input-label'),
            }
        };

        let inputMode = 'usd';

        // Helper: Get Option Data
        function getOptionData(select) {
            const opt = select.options[select.selectedIndex];
            return {
                id: opt.value,
                value: parseFloat(opt.dataset.value),
                code: opt.dataset.code,
                name: opt.dataset.name,
                details: opt.dataset.accountDetails
            };
        }

        // Logic: Switch Mode
        function setInputMode(mode) {
            inputMode = mode;
            const walletData = getOptionData(elements.walletSelect);

            if (mode === 'usd') {
                toggleStyles(elements.toggles.usd, elements.toggles.wallet);
                elements.labels.amountInput.textContent = 'Enter USD Amount';
                elements.inputs.amount.placeholder = '0.00';
            } else {
                toggleStyles(elements.toggles.wallet, elements.toggles.usd);
                elements.labels.amountInput.textContent = `Enter ${walletData.code} Amount`;
                elements.inputs.amount.placeholder = '0.000000';
            }
            calculate();
        }

        // Helper: Toggle Styles
        function toggleStyles(active, inactive) {
            active.classList.remove('bg-transparent', 'text-slate-500', 'font-medium');
            active.classList.add('bg-white', 'text-indigo-600', 'font-bold', 'shadow-sm');

            inactive.classList.remove('bg-white', 'text-indigo-600', 'font-bold', 'shadow-sm');
            inactive.classList.add('bg-transparent', 'text-slate-500', 'font-medium');
        }

        // Logic: Calculate
        function calculate() {
            const wallet = getOptionData(elements.walletSelect);
            const payment = getOptionData(elements.paymentSelect);
            const inputVal = parseFloat(elements.inputs.amount.value) || 0;

            let walletAmt, paymentAmt, usdAmt;

            if (inputMode === 'usd') {
                usdAmt = inputVal;
                walletAmt = wallet.value > 0 ? usdAmt / wallet.value : 0;
                paymentAmt = payment.value > 0 ? usdAmt / payment.value : 0;
            } else {
                walletAmt = inputVal;
                usdAmt = walletAmt * wallet.value;
                paymentAmt = payment.value > 0 ? usdAmt / payment.value : 0;
            }

            // Update Displays
            elements.displays.wallet.textContent = `${walletAmt.toFixed(8)} ${wallet.code}`;
            elements.displays.payment.textContent = `${paymentAmt.toFixed(8)} ${payment.code}`;
            elements.displays.usd.textContent = `USD Equivalent: $${usdAmt.toFixed(2)}`;

            // Update Hidden Inputs
            elements.inputs.submittedAmount.value = paymentAmt.toFixed(8);
            elements.inputs.paymentOptionId.value = payment.id;
            elements.inputs.usdAmount.value = usdAmt.toFixed(2);
        }

        // Logic: Update UI Texts
        function updateUI() {
            const payment = getOptionData(elements.paymentSelect);
            const wallet = getOptionData(elements.walletSelect);

            elements.accountCode.textContent = payment.code;
            elements.accountDetails.textContent = payment.details;
            elements.toggles.walletLabel.textContent = wallet.code;

            // Handle Bank Transfer Logic
            if (payment.name.toLowerCase().includes('bank')) {
                elements.accountDetails.textContent = 'Click "Request Account Details" below.';
                elements.requestBtn.classList.remove('hidden');
            } else {
                elements.requestBtn.classList.add('hidden');
            }

            // Update input label dynamically if in wallet mode
            if (inputMode === 'wallet') {
                elements.labels.amountInput.textContent = `Enter ${wallet.code} Amount`;
            }

            calculate();
        }

        // Events
        elements.toggles.usd.addEventListener('click', () => setInputMode('usd'));
        elements.toggles.wallet.addEventListener('click', () => setInputMode('wallet'));
        elements.walletSelect.addEventListener('change', updateUI);
        elements.paymentSelect.addEventListener('change', updateUI);
        elements.inputs.amount.addEventListener('input', calculate);

        if (elements.requestBtn) {
            elements.requestBtn.addEventListener('click', (e) => {
                e.preventDefault();
                alert('Bank details requested. Please check your email.');
            });
        }

        // Init
        document.addEventListener('DOMContentLoaded', () => {
            updateUI();
            lucide.createIcons();
        });

        // Copy Address Helper
        function copyAddress() {
            const text = document.getElementById('account-details').innerText;
            navigator.clipboard.writeText(text).then(() => alert('Address copied!'));
        }
    </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\exodus-clone-laravel\resources\views/deposit.blade.php ENDPATH**/ ?>