<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <?php if(session('success')): ?>
        <div id="successMessage_c" class="mb-4 rounded-lg bg-green-500 p-4 text-white shadow-md transition-opacity duration-500 ease-in-out">
            <div class="flex items-center">
                <svg class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <span class="ml-3 font-semibold"><?php echo e(session('success')); ?></span>
            </div>
        </div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div id="errorMessage_c" class="mb-4 rounded-lg bg-red-600 p-4 text-white shadow-md transition-opacity duration-500 ease-in-out">
            <div class="flex items-center">
                <svg class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <span class="ml-3 font-semibold">Validation Error</span>
            </div>
            <ul class="mt-2 list-disc list-inside">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
        <div class="border-b border-gray-700 pb-4 mb-4 flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h4 class="text-2xl font-semibold text-white">Investment Plans Management</h4>
                <p class="mt-2 text-gray-400 text-sm">Create, edit, and manage fixed investment plans offered to users.</p>
            </div>
            <div class="mt-4 sm:mt-0 flex items-center gap-4">
                <input type="text" id="planSearch" placeholder="Search plans..."
                       class="px-4 py-2 rounded-md bg-gray-700 border border-gray-600 text-white placeholder-gray-400 focus:outline-none focus:ring-primary-500 focus:border-primary-500 text-sm">
                <button type="button" onclick="openModal('add-plan-modal')"
                        class="px-4 py-2 bg-primary-600 hover:bg-primary-700 text-white rounded-md text-sm font-semibold transition-colors duration-200">Add New Plan</button>
            </div>
        </div>

        <div class="overflow-x-auto">
            <table id="plansTable" class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-700">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tl-lg">Name</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Capital Range</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Daily ROI (%)</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Duration Range</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Features</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tr-lg">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    <?php $__currentLoopData = $investmentPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="bg-[#131319] hover:bg-gray-700 transition-colors duration-200"
                        data-plan-id="<?php echo e($plan->id); ?>"
                        data-plan-name="<?php echo e($plan->name); ?>"
                        data-plan-description="<?php echo e($plan->description); ?>"
                        data-plan-min-investment="<?php echo e($plan->min_investment); ?>"
                        data-plan-max-investment="<?php echo e($plan->max_investment); ?>"
                        data-plan-daily-roi-percentage="<?php echo e($plan->daily_roi_percentage); ?>"
                        data-plan-min-duration-value="<?php echo e($plan->min_duration_value); ?>"
                        data-plan-max-duration-value="<?php echo e($plan->max_duration_value); ?>"
                        data-plan-allowed-duration-units="<?php echo e(json_encode($plan->allowed_duration_units ?? ['days'])); ?>"
                        data-plan-features="<?php echo e(json_encode($plan->features ?? [])); ?>"
                    >
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-white capitalize"><?php echo e($plan->name); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            $<?php echo e(number_format($plan->min_investment, 0)); ?> - $<?php echo e(number_format($plan->max_investment, 0)); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300"><?php echo e(number_format($plan->daily_roi_percentage, 2)); ?>%</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            <?php echo e($plan->min_duration_value); ?> - <?php echo e($plan->max_duration_value); ?> <?php echo e(ucfirst($plan->allowed_duration_units[0] ?? 'days')); ?><?php echo e(($plan->max_duration_value > 1 || $plan->min_duration_value > 1) ? 's' : ''); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-normal text-sm text-gray-300 max-w-xs">
                            <?php if(!empty($plan->features)): ?>
                                <ul class="list-disc list-inside">
                                    <?php $__currentLoopData = $plan->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($feature); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php else: ?>
                                <span class="text-gray-500">N/A</span>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <div class="flex flex-col sm:flex-row gap-2">
                                <button type="button" data-modal-target="edit-plan-modal"
                                        class="open-edit-plan-modal px-3 py-1.5 rounded-md text-white bg-blue-600 hover:bg-blue-700 transition-colors duration-200 text-xs font-medium">Edit</button>
                                <button type="button" data-modal-target="delete-plan-modal"
                                        class="open-delete-plan-modal px-3 py-1.5 rounded-md text-white bg-red-600 hover:bg-red-700 transition-colors duration-200 text-xs font-medium">Delete</button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php if($investmentPlans->isEmpty()): ?>
                        <tr>
                            <td colspan="6" class="px-6 py-8 text-center text-gray-500 text-lg">No investment plans found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div id="paginationControls" class="flex justify-between items-center mt-6">
            <button id="prevPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Previous</button>
            <div id="pageNumbers" class="flex gap-2">
                </div>
            <button id="nextPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Next</button>
        </div>
    </div>

    
    <?php if (isset($component)) { $__componentOriginal9f64f32e90b9102968f2bc548315018c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9f64f32e90b9102968f2bc548315018c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.modal','data' => ['id' => 'add-plan-modal']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'add-plan-modal']); ?>
        <div class="bg-[#131319] rounded-lg shadow-xl p-8 max-w-lg w-full text-center border border-gray-700">
            <div class="border-b border-gray-700 pb-4 mb-6">
                <h2 class="text-2xl font-bold text-white">Add New Investment Plan</h2>
            </div>
            <form action="<?php echo e(route('admin.investment-plans.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="space-y-4 text-left">
                    <div>
                        <label for="add_name" class="block text-sm font-medium text-gray-300 mb-1">Plan Name</label>
                        <input type="text" name="name" id="add_name" maxlength="255" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="add_description" class="block text-sm font-medium text-gray-300 mb-1">Description</label>
                        <textarea name="description" id="add_description" rows="3"
                                  class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500"></textarea>
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="add_min_investment" class="block text-sm font-medium text-gray-300 mb-1">Min Investment (USD)</label>
                            <input type="number" step="0.01" name="min_investment" id="add_min_investment" min="0" required
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                        <div>
                            <label for="add_max_investment" class="block text-sm font-medium text-gray-300 mb-1">Max Investment (USD)</label>
                            <input type="number" step="0.01" name="max_investment" id="add_max_investment" min="0" required
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                    </div>
                    <div>
                        <label for="add_daily_roi_percentage" class="block text-sm font-medium text-gray-300 mb-1">Daily ROI (%)</label>
                        <input type="number" step="0.01" name="daily_roi_percentage" id="add_daily_roi_percentage" min="0" max="100" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="add_min_duration_value" class="block text-sm font-medium text-gray-300 mb-1">Min Duration Value</label>
                            <input type="number" name="min_duration_value" id="add_min_duration_value" min="1" required
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                        <div>
                            <label for="add_max_duration_value" class="block text-sm font-medium text-gray-300 mb-1">Max Duration Value</label>
                            <input type="number" name="max_duration_value" id="add_max_duration_value" min="1" required
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-1">Allowed Duration Units</label>
                        <div id="add_allowed_duration_units_container" class="flex flex-wrap gap-2">
                            <label class="inline-flex items-center text-sm text-gray-300">
                                <input type="checkbox" name="allowed_duration_units[]" value="days" class="form-checkbox text-primary-600 rounded mr-1"> Days
                            </label>
                            <label class="inline-flex items-center text-sm text-gray-300">
                                <input type="checkbox" name="allowed_duration_units[]" value="weeks" class="form-checkbox text-primary-600 rounded mr-1"> Weeks
                            </label>
                            <label class="inline-flex items-center text-sm text-gray-300">
                                <input type="checkbox" name="allowed_duration_units[]" value="months" class="form-checkbox text-primary-600 rounded mr-1"> Months
                            </label>
                            <label class="inline-flex items-center text-sm text-gray-300">
                                <input type="checkbox" name="allowed_duration_units[]" value="years" class="form-checkbox text-primary-600 rounded mr-1"> Years
                            </label>
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-1">Features (up to 3)</label>
                        <div id="add_features_container" class="space-y-2">
                            <input type="text" name="features[]" placeholder="e.g. Personalized support" maxlength="255"
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                            <input type="text" name="features[]" placeholder="e.g. AI-driven optimization" maxlength="255"
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                            <input type="text" name="features[]" placeholder="e.g. Daily market insights" maxlength="255"
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                    </div>
                </div>
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-lg transition-colors duration-200">Add Plan</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('add-plan-modal')">Cancel</button>
                </div>
            </form>
        </div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9f64f32e90b9102968f2bc548315018c)): ?>
<?php $attributes = $__attributesOriginal9f64f32e90b9102968f2bc548315018c; ?>
<?php unset($__attributesOriginal9f64f32e90b9102968f2bc548315018c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9f64f32e90b9102968f2bc548315018c)): ?>
<?php $component = $__componentOriginal9f64f32e90b9102968f2bc548315018c; ?>
<?php unset($__componentOriginal9f64f32e90b9102968f2bc548315018c); ?>
<?php endif; ?>

    
    <?php if (isset($component)) { $__componentOriginal9f64f32e90b9102968f2bc548315018c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9f64f32e90b9102968f2bc548315018c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.modal','data' => ['id' => 'edit-plan-modal']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'edit-plan-modal']); ?>
        <div class="bg-[#131319] rounded-lg shadow-xl p-8 max-w-lg w-full text-center border border-gray-700">
            <div class="border-b border-gray-700 pb-4 mb-6">
                <h2 class="text-2xl font-bold text-white">Edit Investment Plan: <span id="editModalPlanName"></span></h2>
            </div>
            <form action="" method="POST" id="editPlanForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <input type="hidden" name="id" id="editPlanId">
                <div class="space-y-4 text-left">
                    <div>
                        <label for="edit_name" class="block text-sm font-medium text-gray-300 mb-1">Plan Name</label>
                        <input type="text" name="name" id="edit_name" maxlength="255" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="edit_description" class="block text-sm font-medium text-gray-300 mb-1">Description</label>
                        <textarea name="description" id="edit_description" rows="3"
                                  class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500"></textarea>
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="edit_min_investment" class="block text-sm font-medium text-gray-300 mb-1">Min Investment (USD)</label>
                            <input type="number" step="0.01" name="min_investment" id="edit_min_investment" min="0" required
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                        <div>
                            <label for="edit_max_investment" class="block text-sm font-medium text-gray-300 mb-1">Max Investment (USD)</label>
                            <input type="number" step="0.01" name="max_investment" id="edit_max_investment" min="0" required
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                    </div>
                    <div>
                        <label for="edit_daily_roi_percentage" class="block text-sm font-medium text-gray-300 mb-1">Daily ROI (%)</label>
                        <input type="number" step="0.01" name="daily_roi_percentage" id="edit_daily_roi_percentage" min="0" max="100" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="edit_min_duration_value" class="block text-sm font-medium text-gray-300 mb-1">Min Duration Value</label>
                            <input type="number" name="min_duration_value" id="edit_min_duration_value" min="1" required
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                        <div>
                            <label for="edit_max_duration_value" class="block text-sm font-medium text-gray-300 mb-1">Max Duration Value</label>
                            <input type="number" name="max_duration_value" id="edit_max_duration_value" min="1" required
                                   class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-1">Allowed Duration Units</label>
                        <div id="edit_allowed_duration_units_container" class="flex flex-wrap gap-2">
                            
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-1">Features (up to 3)</label>
                        <div id="edit_features_container" class="space-y-2">
                            
                        </div>
                    </div>
                </div>
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-primary-600 hover:bg-primary-700 text-white font-semibold rounded-lg transition-colors duration-200">Save Changes</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('edit-plan-modal')">Cancel</button>
                </div>
            </form>
        </div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9f64f32e90b9102968f2bc548315018c)): ?>
<?php $attributes = $__attributesOriginal9f64f32e90b9102968f2bc548315018c; ?>
<?php unset($__attributesOriginal9f64f32e90b9102968f2bc548315018c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9f64f32e90b9102968f2bc548315018c)): ?>
<?php $component = $__componentOriginal9f64f32e90b9102968f2bc548315018c; ?>
<?php unset($__componentOriginal9f64f32e90b9102968f2bc548315018c); ?>
<?php endif; ?>

    
    <?php if (isset($component)) { $__componentOriginal9f64f32e90b9102968f2bc548315018c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9f64f32e90b9102968f2bc548315018c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.modal','data' => ['id' => 'delete-plan-modal']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'delete-plan-modal']); ?>
        <div class="bg-red-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-red-600">
            <div class="text-white mb-6">
                <svg data-lucide="trash-2" class="mx-auto h-16 w-16 text-white"></svg>
                <h2 class="mt-4 text-2xl font-bold">Delete Investment Plan</h2>
                <p class="mt-2 text-white">Are you sure you want to delete <span id="deleteModalPlanName" class="font-semibold"></span>?</p>
            </div>
            <form action="" method="POST" id="deletePlanForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <input type="hidden" name="id" id="deletePlanId">
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-white hover:bg-gray-100 text-red-700 font-semibold rounded-lg transition-colors duration-200">Yes, Delete</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('delete-plan-modal')">No</button>
                </div>
            </form>
        </div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9f64f32e90b9102968f2bc548315018c)): ?>
<?php $attributes = $__attributesOriginal9f64f32e90b9102968f2bc548315018c; ?>
<?php unset($__attributesOriginal9f64f32e90b9102968f2bc548315018c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9f64f32e90b9102968f2bc548315018c)): ?>
<?php $component = $__componentOriginal9f64f32e90b9102968f2bc548315018c; ?>
<?php unset($__componentOriginal9f64f32e90b9102968f2bc548315018c); ?>
<?php endif; ?>

    <script>
        // Modal and form elements (declarations here remain outside functions)
        // These are elements related to the ADMIN page's modals and table management.
        // They are declared here because they are used by the scripts that run on this specific admin page.
        const plansTable = document.getElementById('plansTable'); // Main table ID for this page
        // Add New Plan Modal elements for validation
        const addPlanForm = document.querySelector('#add-plan-modal form');
        const addFeaturesContainer = document.getElementById('add_features_container');

        // Guard the execution of variable assignments and addEventListeners to prevent errors
        // if this script is loaded on a page without these elements (e.g., a user-facing page).
        if (plansTable) {
            const tbody = plansTable.querySelector('tbody');
            const rows = Array.from(tbody.querySelectorAll('tr'));
            const searchInput = document.getElementById('planSearch');
            const prevButton = document.getElementById('prevPage');
            const nextButton = document.getElementById('nextPage');
            const pageNumbersContainer = document.getElementById('pageNumbers');

            const rowsPerPage = 10;
            let currentPage = 1;
            let filteredRows = [];



            // Edit Plan Modal elements
            const editPlanModal = document.getElementById('edit-plan-modal');
            const editPlanForm = document.getElementById('editPlanForm');
            const editPlanId = document.getElementById('editPlanId');
            const editModalPlanName = document.getElementById('editModalPlanName');
            const editNameInput = document.getElementById('edit_name');
            const editDescriptionInput = document.getElementById('edit_description');
            const editMinInvestmentInput = document.getElementById('edit_min_investment');
            const editMaxInvestmentInput = document.getElementById('edit_max_investment');
            const editDailyRoiPercentageInput = document.getElementById('edit_daily_roi_percentage');
            const editMinDurationValueInput = document.getElementById('edit_min_duration_value');
            const editMaxDurationValueInput = document.getElementById('edit_max_duration_value');
            const editAllowedDurationUnitsContainer = document.getElementById('edit_allowed_duration_units_container');
            const editFeaturesContainer = document.getElementById('edit_features_container');

            // Delete Plan Modal elements
            const deletePlanModal = document.getElementById('delete-plan-modal');
            const deletePlanForm = document.getElementById('deletePlanForm');
            const deletePlanId = document.getElementById('deletePlanId');
            const deleteModalPlanName = document.getElementById('deleteModalPlanName');


            // A function to show validation errors
            function showErrors(errors, container) {
                // First, clear any existing error messages
                container.querySelectorAll('.error-message').forEach(el => el.remove());

                // Iterate through the errors object and display them
                for (const [key, value] of Object.entries(errors)) {
                    const input = container.querySelector(`[name="${key}"], [name^="${key}["]`);
                    if (input) {
                        const errorElement = document.createElement('span');
                        errorElement.className = 'error-message text-red-400 text-sm mt-1 block';
                        errorElement.textContent = value;
                        input.parentElement.appendChild(errorElement);
                    }
                }
            }


            // Function to generate feature input fields for modals (used by admin edit/add)
            function generateFeatureInputs(container, featuresArray = []) {
                container.innerHTML = ''; // Clear previous inputs
                const placeholderFeatures = ['Personalized support', 'AI-driven optimization', 'Daily market insights']; // Fallback placeholders

                // Create inputs for existing features
                featuresArray.forEach((feature, index) => {
                    const input = document.createElement('input');
                    input.type = 'text';
                    input.name = 'features[]';
                    input.placeholder = placeholderFeatures[index] || `Feature ${index + 1}`;
                    input.maxLength = 255;
                    input.value = feature;
                    input.className = 'block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500';
                    container.appendChild(input);
                });

                // Add empty inputs if less than 3 features, or if no features
                for (let i = featuresArray.length; i < 3; i++) {
                    const input = document.createElement('input');
                    input.type = 'text';
                    input.name = 'features[]';
                    input.placeholder = placeholderFeatures[i] || `Feature ${i + 1}`;
                    input.maxLength = 255;
                    input.className = 'block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500';
                    container.appendChild(input);
                }
            }

            // Function to generate allowed duration units checkboxes (for admin edit/add)
            function generateAllowedDurationUnitsCheckboxes(container, allowedUnitsArray = []) {
                container.innerHTML = ''; // Clear previous checkboxes
                const allPossibleUnits = ['days', 'weeks', 'months', 'years'];

                allPossibleUnits.forEach(unit => {
                    const label = document.createElement('label');
                    label.className = 'inline-flex items-center text-sm text-gray-300';
                    const input = document.createElement('input');
                    input.type = 'checkbox';
                    input.name = 'allowed_duration_units[]';
                    input.value = unit;
                    input.checked = allowedUnitsArray.includes(unit);
                    input.className = 'form-checkbox text-primary-600 rounded mr-1';
                    label.appendChild(input);
                    label.appendChild(document.createTextNode(' ' + ucfirst(unit) + (unit === 'days' ? '' : '')));

                    container.appendChild(label);
                });
            }


            // Functions for admin table search and pagination (renderTable, updatePaginationControls)
            function renderTable() {
                const searchTerm = searchInput.value.toLowerCase();
                filteredRows = rows.filter(row => {
                    const textContent = row.textContent.toLowerCase();
                    return textContent.includes(searchTerm);
                });

                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);

                if (totalPages === 0 && searchTerm !== "") {
                    currentPage = 1;
                } else if (totalPages === 0 && searchTerm === "") {
                    currentPage = 1;
                } else if (currentPage > totalPages) {
                    currentPage = totalPages;
                }


                const start = (currentPage - 1) * rowsPerPage;
                const end = start + rowsPerPage;
                const paginatedRows = filteredRows.slice(start, end);

                tbody.innerHTML = '';
                if (paginatedRows.length === 0 && searchTerm !== "") {
                    tbody.innerHTML = `<tr><td colspan="6" class="px-6 py-8 text-center text-gray-500">No matching plans found.</td></tr>`;
                } else if (paginatedRows.length === 0 && searchTerm === "") {
                        tbody.innerHTML = `<tr><td colspan="6" class="px-6 py-8 text-center text-gray-500">No investment plans to display.</td></tr>`;
                }

                paginatedRows.forEach(row => tbody.appendChild(row));

                updatePaginationControls(totalPages);
            }

            function updatePaginationControls(totalPages) {
                prevButton.disabled = currentPage === 1;
                nextButton.disabled = currentPage === totalPages || totalPages === 0;

                pageNumbersContainer.innerHTML = '';
                const maxPageButtons = 5;

                let startPage = Math.max(1, currentPage - Math.floor(maxPageButtons / 2));
                let endPage = Math.min(totalPages, startPage + maxPageButtons - 1);

                if (endPage - startPage + 1 < maxPageButtons) {
                    startPage = Math.max(1, endPage - maxPageButtons + 1);
                }

                if (startPage > 1) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }

                for (let i = startPage; i <= endPage; i++) {
                    const pageButton = document.createElement('button');
                    pageButton.textContent = i;
                    pageButton.className = `px-3 py-1 rounded-md text-sm font-medium ${
                        i === currentPage ? 'bg-primary-600 text-white' : 'bg-gray-700 hover:bg-gray-600 text-gray-300'
                    }`;
                    pageButton.addEventListener('click', () => {
                        currentPage = i;
                        renderTable();
                    });
                    pageNumbersContainer.appendChild(pageButton);
                }

                if (endPage < totalPages) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }
            }

            // Event Listeners for admin table search and pagination
            searchInput.addEventListener('input', () => { currentPage = 1; renderTable(); });
            prevButton.addEventListener('click', () => { if (currentPage > 1) { currentPage--; renderTable(); } });
            nextButton.addEventListener('click', () => { const totalPages = Math.ceil(filteredRows.length / rowsPerPage); if (currentPage < totalPages) { currentPage++; renderTable(); } });


            // Handle opening the single Edit/Delete modals and populating their data (for admin table)
            tbody.addEventListener('click', function(event) {
                const editButton = event.target.closest('.open-edit-plan-modal');
                const deleteButton = event.target.closest('.open-delete-plan-modal');

                if (editButton) {
                    const row = editButton.closest('tr');
                    const planId = row.dataset.planId;
                    const planName = row.dataset.planName;
                    const planDescription = row.dataset.planDescription;
                    const planMinInvestment = row.dataset.planMinInvestment;
                    const planMaxInvestment = row.dataset.planMaxInvestment;
                    const planDailyRoiPercentage = row.dataset.planDailyRoiPercentage;
                    const planMinDurationValue = row.dataset.planMinDurationValue;
                    const planMaxDurationValue = row.dataset.planMaxDurationValue;
                    const planAllowedDurationUnits = JSON.parse(row.dataset.planAllowedDurationUnits);
                    const planFeatures = JSON.parse(row.dataset.planFeatures);

                    // Populate form fields
                    editPlanId.value = planId;
                    editModalPlanName.textContent = planName;
                    editNameInput.value = planName;
                    editDescriptionInput.value = planDescription;
                    editMinInvestmentInput.value = planMinInvestment;
                    editMaxInvestmentInput.value = planMaxInvestment;
                    editDailyRoiPercentageInput.value = planDailyRoiPercentage;
                    editMinDurationValueInput.value = planMinDurationValue;
                    editMaxDurationValueInput.value = planMaxDurationValue;
                    generateAllowedDurationUnitsCheckboxes(editAllowedDurationUnitsContainer, planAllowedDurationUnits);
                    generateFeatureInputs(editFeaturesContainer, planFeatures);

                    // Set form action dynamically
                    editPlanForm.action = `/admin/investment-plans/${planId}`;

                    openModal('edit-plan-modal');
                } else if (deleteButton) {
                    const row = deleteButton.closest('tr');
                    const planId = row.dataset.planId;
                    const planName = row.dataset.planName;

                    deletePlanId.value = planId;
                    deleteModalPlanName.textContent = planName;

                    // Set form action dynamically
                    deletePlanForm.action = `/admin/investment-plans/${planId}`;

                    openModal('delete-plan-modal');
                }
            });
        }


        // Client-side validation for Add Plan Modal
        if (addPlanForm) {
            addPlanForm.addEventListener('submit', function(event) {
                // Clear previous errors first
                showErrors({}, this);

                const formData = new FormData(this);
                const name = formData.get('name');
                const minInvestment = parseFloat(formData.get('min_investment'));
                const maxInvestment = parseFloat(formData.get('max_investment'));
                const dailyRoi = parseFloat(formData.get('daily_roi_percentage'));
                const minDuration = parseInt(formData.get('min_duration_value'));
                const maxDuration = parseInt(formData.get('max_duration_value'));
                const allowedUnits = formData.getAll('allowed_duration_units[]');
                const errors = {};

                // Validation logic
                if (!name) {
                    errors['name'] = 'The plan name is required.';
                }
                if (minInvestment > maxInvestment) {
                    errors['max_investment'] = 'The maximum investment must be greater than or equal to the minimum investment.';
                }
                if (minDuration > maxDuration) {
                    errors['max_duration_value'] = 'The maximum duration must be greater than or equal to the minimum duration.';
                }
                if (dailyRoi < 0 || dailyRoi > 100) {
                    errors['daily_roi_percentage'] = 'The daily ROI must be between 0 and 100.';
                }
                if (allowedUnits.length === 0) {
                    errors['allowed_duration_units'] = 'You must select at least one duration unit.';
                    // Special handling for checkboxes
                    const unitsContainer = document.getElementById('add_allowed_duration_units_container');
                    const errorElement = document.createElement('span');
                    errorElement.className = 'error-message text-red-400 text-sm mt-1 block';
                    errorElement.textContent = errors['allowed_duration_units'];
                    unitsContainer.insertAdjacentElement('afterend', errorElement);
                }

                // Features validation - ensure no more than 3
                const featureInputs = addPlanForm.querySelectorAll('#add_features_container input[name="features[]"]');
                const populatedFeatures = Array.from(featureInputs).filter(input => input.value.trim() !== '');

                if (populatedFeatures.length > 3) {
                    errors['features'] = 'You can add a maximum of 3 features.';
                    const featuresContainer = document.getElementById('add_features_container');
                    const errorElement = document.createElement('span');
                    errorElement.className = 'error-message text-red-400 text-sm mt-1 block';
                    errorElement.textContent = errors['features'];
                    featuresContainer.insertAdjacentElement('afterend', errorElement);
                }

                // Additional simple checks
                if (isNaN(minInvestment) || isNaN(maxInvestment)) errors['min_investment'] = 'Both min and max investment are required.';
                if (isNaN(minDuration) || isNaN(maxDuration)) errors['min_duration_value'] = 'Both min and max duration are required.';

                // If there are any errors, prevent form submission
                if (Object.keys(errors).length > 0) {
                    event.preventDefault();
                    showErrors(errors, this);
                }
            });
        }


        // Client-side validation for Edit Plan Modal
        if (editPlanForm) {
            editPlanForm.addEventListener('submit', function(event) {
                // Clear previous errors first
                showErrors({}, this);

                const formData = new FormData(this);
                const name = formData.get('name');
                const minInvestment = parseFloat(formData.get('min_investment'));
                const maxInvestment = parseFloat(formData.get('max_investment'));
                const dailyRoi = parseFloat(formData.get('daily_roi_percentage'));
                const minDuration = parseInt(formData.get('min_duration_value'));
                const maxDuration = parseInt(formData.get('max_duration_value'));
                const allowedUnits = formData.getAll('allowed_duration_units[]');
                const errors = {};

                // Validation logic (similar to add form)
                if (!name) {
                    errors['name'] = 'The plan name is required.';
                }
                if (minInvestment > maxInvestment) {
                    errors['max_investment'] = 'The maximum investment must be greater than or equal to the minimum investment.';
                }
                if (minDuration > maxDuration) {
                    errors['max_duration_value'] = 'The maximum duration must be greater than or equal to the minimum duration.';
                }
                if (dailyRoi < 0 || dailyRoi > 100) {
                    errors['daily_roi_percentage'] = 'The daily ROI must be between 0 and 100.';
                }
                if (allowedUnits.length === 0) {
                    errors['allowed_duration_units'] = 'You must select at least one duration unit.';
                    const unitsContainer = document.getElementById('edit_allowed_duration_units_container');
                    const errorElement = document.createElement('span');
                    errorElement.className = 'error-message text-red-400 text-sm mt-1 block';
                    errorElement.textContent = errors['allowed_duration_units'];
                    unitsContainer.insertAdjacentElement('afterend', errorElement);
                }

                // Features validation - ensure no more than 3
                const featureInputs = editPlanForm.querySelectorAll('#edit_features_container input[name="features[]"]');
                const populatedFeatures = Array.from(featureInputs).filter(input => input.value.trim() !== '');

                if (populatedFeatures.length > 3) {
                    errors['features'] = 'You can add a maximum of 3 features.';
                    const featuresContainer = document.getElementById('edit_features_container');
                    const errorElement = document.createElement('span');
                    errorElement.className = 'error-message text-red-400 text-sm mt-1 block';
                    errorElement.textContent = errors['features'];
                    featuresContainer.insertAdjacentElement('afterend', errorElement);
                }

                // Additional simple checks
                if (isNaN(minInvestment) || isNaN(maxInvestment)) errors['min_investment'] = 'Both min and max investment are required.';
                if (isNaN(minDuration) || isNaN(maxDuration)) errors['min_duration_value'] = 'Both min and max duration are required.';

                // If there are any errors, prevent form submission
                if (Object.keys(errors).length > 0) {
                    event.preventDefault();
                    showErrors(errors, this);
                }
            });
        }


        // Initial render for admin table (only if `plansTable` exists)
        document.addEventListener('DOMContentLoaded', () => {
            if (plansTable) {
                renderTable();
            }
            // Ensure Lucide icons are initialized on page load
            if (typeof lucide !== 'undefined' && lucide.createIcons) {
                lucide.createIcons();
            }
        });

        // Helper for capitalizing first letter (used by JS and potentially other Blade logic)
        function ucfirst(str) {
            if (typeof str !== 'string' || str.length === 0) {
                return '';
            }
            return str.charAt(0).toUpperCase() + str.slice(1);
        }

        document.addEventListener('DOMContentLoaded', function () {
            // Select the success and error alert containers
            const successAlert = document.querySelector('#successMessage_c');
            const errorAlert = document.querySelector('#errorMessage_c');

            // Function to remove an element
            function removeElement(element) {
                if (element) {
                    // Add a fade-out effect by changing opacity
                    element.style.transition = 'opacity 0.5s ease-in-out';
                    element.style.opacity = '0';

                    // Remove the element from the DOM after the fade-out
                    setTimeout(() => {
                        element.remove();
                    }, 500); // Wait 0.5 seconds for the fade-out to complete
                }
            }

            // Set a timeout to remove the success alert after 10 seconds
            if (successAlert) {
                setTimeout(() => {
                    removeElement(successAlert);
                }, 10000); // 10000 milliseconds = 10 seconds
            }

            // Set a timeout to remove the error alert after 10 seconds
            if (errorAlert) {
                setTimeout(() => {
                    removeElement(errorAlert);
                }, 10000); // 10000 milliseconds = 10 seconds
            }
        });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\metaglobalbrokers-crypto-investment-app-v3.1\resources\views/admin/investment-plans/index.blade.php ENDPATH**/ ?>