<x-user-layout>
    <div class="max-w-[1600px] mx-auto space-y-8">

        {{-- PAGE HEADER --}}
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
            <div>
                <h1 class="text-2xl font-bold text-slate-900 flex items-center gap-3">
                    <div class="w-10 h-10 rounded-full bg-indigo-50 flex items-center justify-center text-indigo-600">
                        <i data-lucide="users" class="w-5 h-5"></i>
                    </div>
                    Referral Program
                </h1>
                <p class="text-sm text-slate-500 mt-1 ml-13">Invite friends and earn rewards.</p>
            </div>
        </div>

        {{-- HERO SECTION --}}
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">

            {{-- REFERRAL LINK CARD --}}
            <div class="lg:col-span-2 bg-gradient-to-r from-indigo-600 to-violet-600 rounded-2xl shadow-xl shadow-indigo-500/20 p-8 text-white relative overflow-hidden">
                <div class="absolute top-0 right-0 w-64 h-64 bg-white opacity-5 rounded-full blur-3xl -mr-16 -mt-16"></div>

                <h2 class="text-2xl font-bold mb-2">Invite friends, earn together</h2>
                <p class="text-indigo-100 mb-8 max-w-lg">Share your unique link with friends. When they sign up and fund their account, you both get rewarded.</p>

                <div class="bg-white/10 backdrop-blur-md rounded-xl p-2 pl-4 flex items-center justify-between border border-white/20 max-w-xl">
                    <div class="truncate text-white/90 font-mono text-sm" id="referral-link">
                        {{ url('/register?referral_code=' . ($user->referral_code ?? 'USER123')) }}
                    </div>
                    <button onclick="copyLink()" class="bg-white text-indigo-600 px-4 py-2 rounded-lg text-sm font-bold hover:bg-gray-50 transition-colors flex items-center gap-2 flex-shrink-0">
                        <i data-lucide="copy" class="w-4 h-4"></i> Copy
                    </button>
                </div>
            </div>

            {{-- STATS GRID --}}
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-1 gap-4">
                {{-- Stat 1 --}}
                <div class="bg-white rounded-2xl p-6 border border-gray-100 shadow-sm flex items-center gap-4">
                    <div class="w-12 h-12 rounded-full bg-blue-50 flex items-center justify-center text-blue-600">
                        <i data-lucide="users" class="w-6 h-6"></i>
                    </div>
                    <div>
                        <p class="text-sm text-slate-500 font-medium">Total Referrals</p>
                        <h3 class="text-2xl font-bold text-slate-900">{{ $referrals->total() }}</h3>
                    </div>
                </div>

                {{-- Stat 2 --}}
                <div class="bg-white rounded-2xl p-6 border border-gray-100 shadow-sm flex items-center gap-4">
                    <div class="w-12 h-12 rounded-full bg-green-50 flex items-center justify-center text-green-600">
                        <i data-lucide="dollar-sign" class="w-6 h-6"></i>
                    </div>
                    <div>
                        <p class="text-sm text-slate-500 font-medium">Total Earned</p>
                        <h3 class="text-2xl font-bold text-slate-900">$0.00</h3>
                    </div>
                </div>
            </div>
        </div>

        {{-- REFERRED USERS TABLE --}}
        <div class="bg-white rounded-2xl border border-gray-100 shadow-sm overflow-hidden">
            <div class="p-6 border-b border-gray-100">
                <h3 class="text-lg font-bold text-slate-800">Referred Users</h3>
            </div>

            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead class="bg-gray-50/50">
                        <tr>
                            <th class="px-6 py-4 text-xs font-semibold text-slate-500 uppercase">User</th>
                            <th class="px-6 py-4 text-xs font-semibold text-slate-500 uppercase">Date Joined</th>
                            <th class="px-6 py-4 text-xs font-semibold text-slate-500 uppercase text-center">Status</th>
                            <th class="px-6 py-4 text-xs font-semibold text-slate-500 uppercase text-right">Commission</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($referrals as $referral)
                            <tr class="hover:bg-gray-50/50 transition-colors">
                                <td class="px-6 py-4">
                                    <div class="flex items-center gap-3">
                                        <div class="w-8 h-8 rounded-full bg-indigo-100 text-indigo-600 flex items-center justify-center text-xs font-bold">
                                            {{ substr($referral->firstname, 0, 1) }}
                                        </div>
                                        <div>
                                            <p class="text-sm font-bold text-slate-900">{{ $referral->firstname }} {{ $referral->lastname }}</p>
                                            <p class="text-xs text-gray-400">{{ $referral->email }}</p>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 text-sm text-slate-500">
                                    {{ $referral->created_at->format('M d, Y') }}
                                </td>
                                <td class="px-6 py-4 text-center">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-bold bg-green-50 text-green-700 border border-green-100">
                                        Active
                                    </span>
                                </td>
                                <td class="px-6 py-4 text-right text-sm font-bold text-slate-700">
                                    $0.00
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="px-6 py-12 text-center text-slate-500">
                                    <div class="flex flex-col items-center justify-center">
                                        <div class="w-12 h-12 bg-gray-50 rounded-full flex items-center justify-center mb-3">
                                            <i data-lucide="user-plus" class="w-6 h-6 text-gray-300"></i>
                                        </div>
                                        <p>You haven't referred anyone yet.</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            {{-- Pagination --}}
            @if($referrals->hasPages())
                <div class="p-6 border-t border-gray-100">
                    {{ $referrals->links() }}
                </div>
            @endif
        </div>

    </div>

    @push('scripts')
    <script>
        function copyLink() {
            const link = document.getElementById('referral-link').innerText;
            navigator.clipboard.writeText(link).then(() => {
                alert('Referral link copied to clipboard!');
            });
        }
    </script>
    @endpush
</x-user-layout>
