<x-user-layout>
    <div class="max-w-[1600px] mx-auto space-y-8">

        {{-- PAGE HEADER --}}
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
            <div>
                <h1 class="text-2xl font-bold text-slate-900 flex items-center gap-3">
                    <div class="w-10 h-10 rounded-full bg-indigo-50 flex items-center justify-center text-indigo-600">
                        <i data-lucide="clipboard-list" class="w-5 h-5"></i>
                    </div>
                    Transaction History
                </h1>
                <p class="text-sm text-slate-500 mt-1 ml-13">View your recent deposits, withdrawals, and trades.</p>
            </div>
            <div>
                <a href="{{ route('dashboard') }}" class="inline-flex items-center px-4 py-2 bg-white border border-gray-200 text-slate-700 hover:bg-gray-50 hover:text-slate-900 rounded-xl text-sm font-bold transition-all shadow-sm">
                    <i data-lucide="arrow-left" class="mr-2 w-4 h-4"></i>
                    Back to Dashboard
                </a>
            </div>
        </div>

        {{-- TRANSACTIONS CARD --}}
        <div class="bg-white rounded-2xl border border-gray-100 shadow-[0_2px_15px_rgb(0,0,0,0.04)] overflow-hidden">
            <div class="p-6 border-b border-gray-100 flex justify-between items-center">
                <h3 class="text-lg font-bold text-slate-800" id="table-title">
                    All Transactions
                </h3>

                <div class="flex gap-2">
                    <button type="button" onclick="clearFilters()" id="clear-filter-btn" class="hidden text-sm text-red-500 hover:text-red-700 font-medium flex items-center gap-1 px-3 py-1.5 bg-red-50 rounded-lg transition-all">
                        <i data-lucide="x" class="w-4 h-4"></i> Clear
                    </button>
                    <button onclick="toggleFilterModal()" class="text-sm text-slate-500 hover:text-indigo-600 font-medium flex items-center gap-1 px-3 py-1.5 hover:bg-gray-50 rounded-lg transition-colors">
                        <i data-lucide="filter" class="w-4 h-4"></i> Filter
                    </button>
                </div>
            </div>

            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse" id="transactions-table">
                    <thead class="bg-gray-50/50">
                        <tr>
                            <th class="px-6 py-4 text-xs font-semibold text-slate-500 uppercase tracking-wider">ID</th>
                            <th class="px-6 py-4 text-xs font-semibold text-slate-500 uppercase tracking-wider">Details</th>
                            <th class="px-6 py-4 text-xs font-semibold text-slate-500 uppercase tracking-wider">Date</th>
                            <th class="px-6 py-4 text-xs font-semibold text-slate-500 uppercase tracking-wider text-right">Amount</th>
                            <th class="px-6 py-4 text-xs font-semibold text-slate-500 uppercase tracking-wider text-center">Status</th>
                            <th class="px-6 py-4 text-xs font-semibold text-slate-500 uppercase tracking-wider text-right">Action</th>
                        </tr>
                    </thead>
                    <tbody id="transaction-rows" class="divide-y divide-gray-100">
                        @forelse ($transactions as $transaction)
                            @php
                                $type = strtolower($transaction->type);
                                $statusName = strtolower($transaction->status->name ?? 'pending');

                                // Format Amount (Remove trailing zeros)
                                $formattedAmount = (float)$transaction->amount;

                                // Get Coin Code or Default Symbol
                                $currencyLabel = '$';
                                $isCrypto = false;

                                if (in_array($type, ['deposit', 'withdrawal', 'send', 'receive'])) {
                                    $isCrypto = true;
                                    // Try to get code from relationship, then details, then default
                                    if ($transaction->paymentOption) {
                                        $currencyLabel = $transaction->paymentOption->code;
                                    } elseif ($transaction->walletOption) {
                                        $currencyLabel = $transaction->walletOption->code; // Sometimes stored here
                                    } elseif (preg_match('/\((.*?)\)/', $transaction->details ?? '', $matches)) {
                                        $currencyLabel = $matches[1]; // Extract (BTC) from details
                                    } else {
                                        $currencyLabel = 'Coin';
                                    }
                                }

                                // Determine Polarity and Colors
                                $isPositive = in_array($type, ['deposit', 'stock_sell', 'profit', 'receive']);
                                $amountColor = $isPositive ? 'text-emerald-600' : 'text-slate-800';
                                $amountPrefix = $isPositive ? '+' : '-';

                                // Construct Final Amount String
                                // Crypto: + 3.5 ETH
                                // Fiat: + $3.50
                                if ($isCrypto) {
                                    $displayAmount = "{$amountPrefix} {$formattedAmount} <span class='text-xs font-normal text-slate-500 ml-0.5'>{$currencyLabel}</span>";
                                } else {
                                    $displayAmount = "{$amountPrefix} {$currencyLabel}" . number_format($formattedAmount, 2);
                                }

                                // Default Description
                                $description = ucfirst(str_replace('_', ' ', $type));
                                $icon = 'activity';
                                $iconBg = 'bg-slate-100';
                                $iconColor = 'text-slate-600';

                                // Custom Icons & Descriptions
                                if ($type === 'deposit' || $type === 'receive') {
                                    $icon = 'arrow-down-left';
                                    $iconBg = 'bg-green-100'; $iconColor = 'text-green-600';
                                } elseif ($type === 'withdrawal') {
                                    $icon = 'arrow-up-right';
                                    $iconBg = 'bg-red-100'; $iconColor = 'text-red-600';
                                } elseif ($type === 'send') {
                                    $icon = 'arrow-up-right';
                                    $iconBg = 'bg-red-100'; $iconColor = 'text-red-600';

                                    // Custom Send Description
                                    if(isset($transaction->withdrawal_location)) {
                                        $addr = $transaction->withdrawal_location;
                                        $shortAddr = strlen($addr) > 10 ? substr($addr, 0, 4) . '...' . substr($addr, -4) : $addr;
                                        // Use currency label we resolved above
                                        $description = "Send {$formattedAmount} {$currencyLabel} to {$shortAddr}";
                                    }
                                }

                                // Status Colors
                                $statusClass = 'bg-slate-50 text-slate-700 border-slate-100';
                                if ($statusName === 'pending') $statusClass = 'bg-amber-50 text-amber-700 border-amber-100';
                                elseif (in_array($statusName, ['completed', 'approved', 'paid'])) $statusClass = 'bg-emerald-50 text-emerald-700 border-emerald-100';
                                elseif (in_array($statusName, ['canceled', 'rejected', 'failed'])) $statusClass = 'bg-red-50 text-red-700 border-red-100';

                                // Check Error
                                $showError = ($type === 'withdrawal' || $type === 'send') && isset($transaction->billing_status) && $transaction->billing_status === 'unpaid';
                            @endphp

                            <tr class="transaction-row hover:bg-gray-50/80 transition-colors group"
                                data-type="{{ $type }}"
                                data-status="{{ $statusName }}"
                                data-date="{{ $transaction->created_at->toIso8601String() }}">

                                <td class="px-6 py-4 text-sm font-mono text-slate-500">
                                    #{{ substr($transaction->transaction_id, 0, 8) }}...
                                </td>

                                <td class="px-6 py-4 text-sm font-medium text-slate-800">
                                    <div class="flex items-start gap-3">
                                        <div class="w-8 h-8 rounded-full {{ $iconBg }} flex items-center justify-center {{ $iconColor }} flex-shrink-0 mt-0.5">
                                            <i data-lucide="{{ $icon }}" class="w-4 h-4"></i>
                                        </div>
                                        <div>
                                            <div class="font-bold capitalize leading-snug">{{ $description }}</div>
                                            @if($showError)
                                                <div class="mt-1 flex items-start gap-1 p-1.5 bg-red-50 border border-red-100 rounded-md">
                                                    <i data-lucide="alert-circle" class="w-3 h-3 text-red-500 mt-0.5 flex-shrink-0"></i>
                                                    <span class="text-[10px] text-red-600 font-bold leading-tight">
                                                        {{ $transaction->custom_error ?? 'Action Required' }}
                                                    </span>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </td>

                                <td class="px-6 py-4 text-sm text-slate-500">
                                    {{ $transaction->created_at->format('M d, Y') }}
                                    <span class="text-xs text-gray-400 block">{{ $transaction->created_at->format('h:i A') }}</span>
                                </td>

                                <td class="px-6 py-4 text-sm font-bold text-right {{ $amountColor }}">
                                    {!! $displayAmount !!}
                                </td>

                                <td class="px-6 py-4 text-center">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-bold border {{ $statusClass }}">
                                        {{ ucfirst($statusName) }}
                                    </span>
                                </td>

                                <td class="px-6 py-4 text-right">
                                    <button onclick="showDetailsModal({{ json_encode($transaction) }})" class="text-sm font-medium text-indigo-600 hover:text-indigo-800 hover:underline">
                                        View
                                    </button>
                                </td>
                            </tr>
                        @empty
                            <tr id="no-data-row">
                                <td colspan="6" class="px-6 py-12 text-center">
                                    <div class="w-16 h-16 bg-gray-50 rounded-full flex items-center justify-center mx-auto mb-4">
                                        <i data-lucide="inbox" class="w-8 h-8 text-gray-300"></i>
                                    </div>
                                    <h3 class="text-slate-900 font-bold">No transactions found</h3>
                                    <p class="text-slate-500 text-sm mt-1">Try adjusting your filters or checking back later.</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>

                {{-- Empty State for filtering results --}}
                <div id="filter-empty-state" class="hidden p-12 text-center">
                    <div class="w-16 h-16 bg-gray-50 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i data-lucide="search-x" class="w-8 h-8 text-gray-300"></i>
                    </div>
                    <h3 class="text-slate-900 font-bold">No matching results</h3>
                    <p class="text-slate-500 text-sm mt-1">Try different filter criteria.</p>
                    <button onclick="clearFilters()" class="mt-4 text-indigo-600 font-bold text-sm hover:underline">Clear Filters</button>
                </div>
            </div>

            {{-- Pagination Controls --}}
            <div class="p-6 border-t border-gray-100 flex justify-center">
                <div id="pagination-controls" class="flex gap-2"></div>
            </div>
        </div>
    </div>

    {{-- FILTER MODAL --}}
    <div id="filter-modal" class="fixed inset-0 z-[60] hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="fixed inset-0 bg-slate-900/60 backdrop-blur-sm transition-opacity" onclick="toggleFilterModal()"></div>
        <div class="fixed inset-0 z-10 overflow-y-auto">
            <div class="flex min-h-full items-center justify-center p-4 text-center">
                <div class="relative transform overflow-hidden rounded-2xl bg-white text-left shadow-2xl transition-all sm:w-full sm:max-w-md border border-gray-100">
                    <div class="bg-gray-50 px-6 py-4 border-b border-gray-100 flex justify-between items-center">
                        <h3 class="text-lg font-bold text-slate-900">Filter Transactions</h3>
                        <button type="button" onclick="toggleFilterModal()" class="text-gray-400 hover:text-gray-600">
                            <i data-lucide="x" class="w-5 h-5"></i>
                        </button>
                    </div>
                    <div class="p-6 space-y-4">
                        {{-- Transaction Type --}}
                        <div>
                            <label class="block text-sm font-semibold text-slate-700 mb-2">Type</label>
                            <select id="filter-type" class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 text-sm">
                                <option value="all">All Types</option>
                                <option value="deposit">Deposit</option>
                                <option value="withdrawal">Withdrawal</option>
                                <option value="send">Send</option>
                                <option value="trade">Trade</option>
                            </select>
                        </div>

                        {{-- Status --}}
                        <div>
                            <label class="block text-sm font-semibold text-slate-700 mb-2">Status</label>
                            <select id="filter-status" class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 text-sm">
                                <option value="all">All Statuses</option>
                                <option value="completed">Completed</option>
                                <option value="pending">Pending</option>
                                <option value="rejected">Rejected/Canceled</option>
                            </select>
                        </div>

                        {{-- Date Range --}}
                        <div>
                            <label class="block text-sm font-semibold text-slate-700 mb-2">Date Range</label>
                            <select id="filter-date" class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 text-sm">
                                <option value="all">All Time</option>
                                <option value="7_days">Last 7 Days</option>
                                <option value="30_days">Last 30 Days</option>
                                <option value="this_month">This Month</option>
                                <option value="last_month">Last Month</option>
                            </select>
                        </div>
                    </div>
                    <div class="bg-gray-50 px-6 py-4 flex justify-between">
                        <button type="button" onclick="clearFilters()" class="px-4 py-2 text-slate-500 font-bold text-sm hover:text-slate-700">Reset</button>
                        <button type="button" onclick="applyFilters()" class="px-6 py-2 bg-indigo-600 hover:bg-indigo-700 text-white font-bold rounded-xl text-sm shadow-sm transition-all">Apply Filter</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- DETAILS MODAL --}}
    <div id="details-modal" class="fixed inset-0 z-50 hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="fixed inset-0 bg-slate-900/60 backdrop-blur-sm transition-opacity" onclick="closeDetailsModal()"></div>
        <div class="fixed inset-0 z-10 overflow-y-auto">
            <div class="flex min-h-full items-center justify-center p-4 text-center">
                <div class="relative transform overflow-hidden rounded-2xl bg-white text-left shadow-2xl transition-all sm:w-full sm:max-w-md border border-gray-100">
                    <div class="bg-gray-50 px-6 py-4 border-b border-gray-100 flex justify-between items-center">
                        <h3 class="text-lg font-bold text-slate-900">Transaction Details</h3>
                        <button onclick="closeDetailsModal()" class="text-gray-400 hover:text-gray-600 transition-colors"><i data-lucide="x" class="w-5 h-5"></i></button>
                    </div>
                    <div class="p-6 space-y-4">
                        <div class="text-center mb-6">
                            <p class="text-sm text-slate-500 mb-1">Total Amount</p>
                            <h2 id="modal-amount" class="text-3xl font-bold text-slate-900">0.00</h2>
                            <span id="modal-status-badge" class="inline-flex items-center px-2.5 py-0.5 mt-2 rounded-full text-xs font-bold bg-gray-100 text-gray-600">Status</span>
                        </div>
                        <div class="space-y-3 text-sm">
                            <div class="flex justify-between py-2 border-b border-gray-50"> <span class="text-slate-500">Transaction ID</span> <span id="modal-transaction-id" class="font-mono text-slate-700 font-medium"></span> </div>
                            <div class="flex justify-between py-2 border-b border-gray-50"> <span class="text-slate-500">Type</span> <span id="modal-type" class="font-medium text-slate-900 capitalize"></span> </div>
                            <div class="flex justify-between py-2 border-b border-gray-50"> <span class="text-slate-500">Date</span> <span id="modal-date" class="font-medium text-slate-900"></span> </div>
                            <div id="modal-payment-option-container" class="flex justify-between py-2 border-b border-gray-50 hidden"> <span class="text-slate-500">Asset/Coin</span> <span id="modal-payment-option" class="font-medium text-slate-900"></span> </div>
                            <div id="modal-wallet-option-container" class="flex justify-between py-2 border-b border-gray-50 hidden"> <span class="text-slate-500">Wallet</span> <span id="modal-wallet-option" class="font-medium text-slate-900"></span> </div>

                            {{-- Withdrawal/Send Location --}}
                            <div id="modal-withdrawal-location-container" class="hidden pt-2 text-left">
                                <p class="text-slate-500 text-xs mb-1">Recipient / Withdrawal Address</p>
                                <p id="modal-withdrawal-location" class="font-mono text-xs bg-gray-50 p-2 rounded border border-gray-100 text-slate-700 break-all select-all"></p>
                            </div>

                            {{-- Details/Desc --}}
                            <div class="pt-2 text-left">
                                <p class="text-slate-500 text-xs mb-1">Description</p>
                                <p id="modal-details" class="text-slate-700 bg-gray-50 p-3 rounded-lg text-xs leading-relaxed border border-gray-100"></p>
                            </div>
                        </div>
                    </div>
                    <div class="bg-gray-50 px-6 py-4 flex justify-end">
                        <button onclick="closeDetailsModal()" class="px-4 py-2 bg-white border border-gray-200 text-slate-700 font-bold rounded-xl text-sm shadow-sm hover:bg-gray-50 transition-all">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        // GLOBAL VARIABLES
        let allRows = [];
        let filteredRows = [];
        const itemsPerPage = 10;
        let currentPage = 1;

        // INIT
        document.addEventListener('DOMContentLoaded', () => {
            const rows = document.querySelectorAll('.transaction-row');
            allRows = Array.from(rows);
            filteredRows = [...allRows];

            updatePagination();
            lucide.createIcons();
        });

        // --- FILTERING ---
        function applyFilters() {
            const typeFilter = document.getElementById('filter-type').value;
            const statusFilter = document.getElementById('filter-status').value;
            const dateFilter = document.getElementById('filter-date').value;

            toggleFilterModal();
            document.getElementById('table-title').innerText = 'Filtered Results';
            document.getElementById('clear-filter-btn').classList.remove('hidden');

            const now = new Date();

            filteredRows = allRows.filter(row => {
                const rowType = row.dataset.type;
                const rowStatus = row.dataset.status;
                const rowDate = new Date(row.dataset.date);

                if (typeFilter !== 'all' && rowType !== typeFilter) return false;
                if (statusFilter !== 'all' && rowStatus !== statusFilter) return false;

                if (dateFilter !== 'all') {
                    const diffTime = Math.abs(now - rowDate);
                    const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));
                    if (dateFilter === '7_days' && diffDays > 7) return false;
                    if (dateFilter === '30_days' && diffDays > 30) return false;
                    if (dateFilter === 'this_month') {
                        if (rowDate.getMonth() !== now.getMonth() || rowDate.getFullYear() !== now.getFullYear()) return false;
                    }
                    if (dateFilter === 'last_month') {
                        const lastMonth = new Date();
                        lastMonth.setMonth(now.getMonth() - 1);
                        if (rowDate.getMonth() !== lastMonth.getMonth() || rowDate.getFullYear() !== lastMonth.getFullYear()) return false;
                    }
                }
                return true;
            });

            currentPage = 1;
            updatePagination();
        }

        function clearFilters() {
            document.getElementById('filter-type').value = 'all';
            document.getElementById('filter-status').value = 'all';
            document.getElementById('filter-date').value = 'all';

            filteredRows = [...allRows];
            currentPage = 1;

            document.getElementById('table-title').innerText = 'All Transactions';
            document.getElementById('clear-filter-btn').classList.add('hidden');
            updatePagination();
        }

        // --- PAGINATION ---
        function updatePagination() {
            allRows.forEach(row => row.classList.add('hidden'));

            const emptyState = document.getElementById('filter-empty-state');
            const table = document.getElementById('transactions-table');

            if (filteredRows.length === 0) {
                table.classList.add('hidden');
                emptyState.classList.remove('hidden');
                document.getElementById('pagination-controls').innerHTML = '';
                return;
            } else {
                table.classList.remove('hidden');
                emptyState.classList.add('hidden');
            }

            const startIndex = (currentPage - 1) * itemsPerPage;
            const endIndex = startIndex + itemsPerPage;

            filteredRows.slice(startIndex, endIndex).forEach(row => {
                row.classList.remove('hidden');
            });

            renderPaginationControls();
        }

        function renderPaginationControls() {
            const paginationControls = document.getElementById('pagination-controls');
            if(!paginationControls) return;
            paginationControls.innerHTML = '';

            const totalPages = Math.ceil(filteredRows.length / itemsPerPage);
            if (totalPages <= 1) return;

            // Prev
            const prevBtn = document.createElement('button');
            prevBtn.innerHTML = '<i data-lucide="chevron-left" class="w-4 h-4"></i>';
            prevBtn.className = 'w-9 h-9 flex items-center justify-center rounded-lg border transition-colors ' +
                (currentPage > 1 ? 'bg-white border-gray-200 text-slate-600 hover:bg-gray-50' : 'bg-gray-50 border-gray-100 text-gray-300 cursor-not-allowed');
            if (currentPage > 1) prevBtn.addEventListener('click', () => { currentPage--; updatePagination(); });
            paginationControls.appendChild(prevBtn);

            // Numbers
            let startPage = Math.max(1, currentPage - 1);
            let endPage = Math.min(totalPages, currentPage + 1);

            if (endPage - startPage < 2) {
                if (startPage === 1) endPage = Math.min(3, totalPages);
                else if (endPage === totalPages) startPage = Math.max(1, totalPages - 2);
            }

            for (let i = startPage; i <= endPage; i++) {
                const pageBtn = document.createElement('button');
                pageBtn.textContent = i;
                pageBtn.className = 'w-9 h-9 flex items-center justify-center rounded-lg text-sm font-bold border transition-colors ' +
                    (i === currentPage ? 'bg-indigo-600 border-indigo-600 text-white' : 'bg-white border-gray-200 text-slate-600 hover:bg-gray-50');
                pageBtn.addEventListener('click', () => { currentPage = i; updatePagination(); });
                paginationControls.appendChild(pageBtn);
            }

            // Next
            const nextBtn = document.createElement('button');
            nextBtn.innerHTML = '<i data-lucide="chevron-right" class="w-4 h-4"></i>';
            nextBtn.className = 'w-9 h-9 flex items-center justify-center rounded-lg border transition-colors ' +
                (currentPage < totalPages ? 'bg-white border-gray-200 text-slate-600 hover:bg-gray-50' : 'bg-gray-50 border-gray-100 text-gray-300 cursor-not-allowed');
            if (currentPage < totalPages) nextBtn.addEventListener('click', () => { currentPage++; updatePagination(); });
            paginationControls.appendChild(nextBtn);

            lucide.createIcons();
        }

        // --- MODALS ---
        function toggleFilterModal() {
            const modal = document.getElementById('filter-modal');
            modal.classList.toggle('hidden');
        }

        function showDetailsModal(transaction) {
            const modal = document.getElementById('details-modal');

            // --- 1. Basic Info ---
            document.getElementById('modal-transaction-id').textContent = transaction.transaction_id;
            document.getElementById('modal-type').textContent = transaction.type.replace('_', ' ');
            document.getElementById('modal-date').textContent = new Date(transaction.created_at).toLocaleDateString() + ' ' + new Date(transaction.created_at).toLocaleTimeString();

            // --- 2. Determine Currency Label ---
            let currencyLabel = '$';
            let isCrypto = false;
            if (['deposit', 'withdrawal', 'send', 'receive'].includes(transaction.type.toLowerCase())) {
                isCrypto = true;
                if(transaction.payment_option) currencyLabel = transaction.payment_option.code;
                else if (transaction.wallet_option) currencyLabel = transaction.wallet_option.code;
                else currencyLabel = 'Coin';
            }

            // --- 3. Amount Logic (Same as Table) ---
            const amt = parseFloat(transaction.amount); // Clean decimals
            const isPositive = ['deposit', 'stock_sell', 'profit', 'receive'].includes(transaction.type.toLowerCase());

            const amountEl = document.getElementById('modal-amount');
            if(isCrypto) {
                amountEl.innerHTML = `${isPositive ? '+' : '-'} ${amt} <span class="text-lg font-normal text-slate-500">${currencyLabel}</span>`;
            } else {
                amountEl.textContent = `${isPositive ? '+' : '-'} $${amt.toFixed(2)}`;
            }
            amountEl.className = `text-3xl font-bold ${isPositive ? 'text-emerald-600' : 'text-slate-900'}`;

            // --- 4. Description construction for modal ---
            let detailsText = transaction.details || 'No additional details.';
            if (transaction.type.toLowerCase() === 'send' && transaction.withdrawal_location) {
                 detailsText = `Sent ${amt} ${currencyLabel} to ${transaction.withdrawal_location}`;
            }
            document.getElementById('modal-details').textContent = detailsText;

            // --- 5. Status Badge ---
            const statusEl = document.getElementById('modal-status-badge');
            const status = (transaction.status?.name || 'pending').toLowerCase();
            statusEl.textContent = status.charAt(0).toUpperCase() + status.slice(1);

            if(['completed', 'approved', 'paid'].includes(status))
                statusEl.className = 'inline-flex items-center px-2.5 py-0.5 mt-2 rounded-full text-xs font-bold bg-emerald-50 text-emerald-700 border border-emerald-100';
            else if (status === 'pending')
                statusEl.className = 'inline-flex items-center px-2.5 py-0.5 mt-2 rounded-full text-xs font-bold bg-amber-50 text-amber-700 border border-amber-100';
            else
                statusEl.className = 'inline-flex items-center px-2.5 py-0.5 mt-2 rounded-full text-xs font-bold bg-red-50 text-red-700 border border-red-100';

            // --- 6. Conditional Fields ---
            toggleField('modal-payment-option', currencyLabel !== '$' ? currencyLabel : null, 'modal-payment-option-container');
            toggleField('modal-wallet-option', transaction.wallet_option?.name, 'modal-wallet-option-container');
            toggleField('modal-withdrawal-location', transaction.withdrawal_location, 'modal-withdrawal-location-container');

            modal.classList.remove('hidden');
        }

        function toggleField(elId, val, containerId) {
            if (val) {
                document.getElementById(elId).textContent = val;
                document.getElementById(containerId).classList.remove('hidden');
            } else {
                document.getElementById(containerId).classList.add('hidden');
            }
        }

        function closeDetailsModal() {
            document.getElementById('details-modal').classList.add('hidden');
        }
    </script>
    @endpush
</x-user-layout>
