<x-app-layout>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">

        {{-- Page Title --}}
        <h1 class="text-2xl font-bold text-white mb-6">Trade History & Positions</h1>

        {{-- Notifications --}}
        @if (session('success'))
            <div class="mb-4 p-4 bg-green-900 text-green-200 rounded-lg border border-green-700">
                {{ session('success') }}
            </div>
        @endif
        @if (session('error'))
            <div class="mb-4 p-4 bg-red-900 text-red-200 rounded-lg border border-red-700">
                {{ session('error') }}
            </div>
        @endif

        {{-- ================= SECTION 1: OPEN FOREX POSITIONS ================= --}}
        <div class="bg-[#131319] rounded-lg shadow-lg border border-gray-700 mb-8 overflow-hidden">
            <div class="p-4 border-b border-gray-700 bg-gray-800/50 flex justify-between items-center">
                <h2 class="text-lg font-semibold text-white">Open Forex Positions</h2>
                <span class="text-xs text-gray-400">Net Holdings</span>
            </div>

            <div class="overflow-x-auto">
                <table class="w-full text-left text-sm text-gray-400">
                    <thead class="bg-gray-800 text-gray-200 uppercase text-xs">
                        <tr>
                            <th class="px-6 py-3">Pair</th>
                            <th class="px-6 py-3">Units Held</th>
                            <th class="px-6 py-3">Avg Entry</th>
                            <th class="px-6 py-3">Current Price</th>
                            <th class="px-6 py-3">Est. Value</th>
                            <th class="px-6 py-3 text-right">Action</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-700">
                        @forelse ($openForexPositions as $pos)
                            @php
                                $currentPrice = $pos->pair->exchange_rate;
                                $value = $pos->balance * $currentPrice;
                                $pnl = ($currentPrice - $pos->avg_entry_price) * $pos->balance;
                                $isProfit = $pnl >= 0;
                            @endphp
                            <tr class="hover:bg-gray-800/50 transition-colors">
                                <td class="px-6 py-4 font-bold text-white">{{ $pos->pair->symbol }}</td>
                                <td class="px-6 py-4">{{ number_format($pos->balance, 2) }}</td>
                                <td class="px-6 py-4 text-gray-300">{{ number_format($pos->avg_entry_price, 4) }}</td>
                                <td class="px-6 py-4 text-white">{{ number_format($currentPrice, 4) }}</td>
                                <td class="px-6 py-4 font-mono">
                                    ${{ number_format($value, 2) }}
                                    <span class="text-xs block {{ $isProfit ? 'text-green-400' : 'text-red-400' }}">
                                        {{ $isProfit ? '+' : '' }}{{ number_format($pnl, 2) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 text-right">
                                    <form action="{{ route('trades.forex.close') }}" method="POST" onsubmit="return confirm('Are you sure you want to close this position? This will sell all units at current market price.');">
                                        @csrf
                                        <input type="hidden" name="wallet_id" value="{{ $pos->id }}">
                                        <button type="submit" class="px-3 py-1 bg-red-600 hover:bg-red-700 text-white rounded text-xs font-semibold transition-colors">
                                            Close Position
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="px-6 py-8 text-center text-gray-500">No open forex positions.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        {{-- ================= SECTION 2: HISTORY TABS ================= --}}
        <div class="mb-4 border-b border-gray-700">
            <ul class="flex flex-wrap -mb-px text-sm font-medium text-center" id="history-tabs" role="tablist">
                <li class="mr-2" role="presentation">
                    <button class="inline-block p-4 text-blue-500 border-b-2 border-blue-500 rounded-t-lg hover:text-blue-400" id="forex-tab" type="button">Forex History</button>
                </li>
                <li class="mr-2" role="presentation">
                    <button class="inline-block p-4 text-gray-400 border-b-2 border-transparent rounded-t-lg hover:text-gray-300" id="stock-tab" type="button">Stock History</button>
                </li>
            </ul>
        </div>

        <div id="tab-content">
            {{-- FOREX HISTORY TABLE --}}
            <div class="hidden p-4 rounded-lg bg-[#131319] border border-gray-700" id="forex-history">

                {{-- Filter --}}
                <div class="mb-4">
                    <input type="text" id="forex-search" class="bg-gray-800 border border-gray-600 text-white text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 max-w-sm" placeholder="Search Symbol (e.g. EUR/USD)">
                </div>

                <div class="overflow-x-auto">
                    <table class="w-full text-left text-sm text-gray-400">
                        <thead class="bg-gray-800 text-gray-200 uppercase text-xs">
                            <tr>
                                <th class="px-6 py-3">Date</th>
                                <th class="px-6 py-3">Symbol</th>
                                <th class="px-6 py-3">Type</th>
                                <th class="px-6 py-3">Units</th>
                                <th class="px-6 py-3">Entry Price</th>
                                <th class="px-6 py-3">Leverage</th>
                                <th class="px-6 py-3">Margin/Cost</th>
                            </tr>
                        </thead>
                        <tbody id="forex-table-body" class="divide-y divide-gray-700">
                            @forelse ($forexTrades as $trade)
                                <tr class="hover:bg-gray-800/50">
                                    <td class="px-6 py-4">{{ $trade->created_at->format('M d, Y H:i') }}</td>
                                    <td class="px-6 py-4 font-bold text-white">{{ $trade->pair->symbol }}</td>
                                    <td class="px-6 py-4">
                                        <span class="px-2 py-1 rounded text-xs font-bold {{ $trade->type === 'buy' ? 'bg-green-900 text-green-300' : 'bg-red-900 text-red-300' }}">
                                            {{ strtoupper($trade->type) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4">{{ number_format($trade->quantity, 2) }}</td>
                                    <td class="px-6 py-4">{{ number_format($trade->entry_price, 4) }}</td>
                                    <td class="px-6 py-4">1:{{ $trade->leverage_used }}</td>
                                    <td class="px-6 py-4 text-white">${{ number_format($trade->margin_amount, 2) }}</td>
                                </tr>
                            @empty
                                <tr><td colspan="7" class="px-6 py-4 text-center">No forex trade history.</td></tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            {{-- STOCK HISTORY TABLE --}}
            <div class="hidden p-4 rounded-lg bg-[#131319] border border-gray-700" id="stock-history">
                 <div class="overflow-x-auto">
                    <table class="w-full text-left text-sm text-gray-400">
                        <thead class="bg-gray-800 text-gray-200 uppercase text-xs">
                            <tr>
                                <th class="px-6 py-3">Date</th>
                                <th class="px-6 py-3">Code</th>
                                <th class="px-6 py-3">Type</th>
                                <th class="px-6 py-3">Quantity</th>
                                <th class="px-6 py-3">Price</th>
                                <th class="px-6 py-3">Account</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-700">
                            @forelse ($stockTrades as $trade)
                                <tr class="hover:bg-gray-800/50">
                                    <td class="px-6 py-4">{{ $trade->created_at->format('M d, Y H:i') }}</td>
                                    <td class="px-6 py-4 font-bold text-white">{{ $trade->stock->code }}</td>
                                    <td class="px-6 py-4">
                                        <span class="px-2 py-1 rounded text-xs font-bold {{ $trade->trade_action === 'buy' ? 'bg-green-900 text-green-300' : 'bg-red-900 text-red-300' }}">
                                            {{ strtoupper($trade->trade_action) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4">{{ number_format($trade->shares_quantity ?? 0, 4) }}</td>
                                    <td class="px-6 py-4">${{ number_format($trade->price_per_share, 2) }}</td>
                                    <td class="px-6 py-4 uppercase text-xs">{{ $trade->account_type }}</td>
                                </tr>
                            @empty
                                <tr><td colspan="6" class="px-6 py-4 text-center">No stock trade history.</td></tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>

    @push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // --- TAB LOGIC ---
            const forexTab = document.getElementById('forex-tab');
            const stockTab = document.getElementById('stock-tab');
            const forexContent = document.getElementById('forex-history');
            const stockContent = document.getElementById('stock-history');

            function switchTab(active) {
                if (active === 'forex') {
                    forexContent.classList.remove('hidden');
                    stockContent.classList.add('hidden');

                    forexTab.classList.add('text-blue-500', 'border-blue-500');
                    forexTab.classList.remove('text-gray-400', 'border-transparent');

                    stockTab.classList.remove('text-blue-500', 'border-blue-500');
                    stockTab.classList.add('text-gray-400', 'border-transparent');
                } else {
                    stockContent.classList.remove('hidden');
                    forexContent.classList.add('hidden');

                    stockTab.classList.add('text-blue-500', 'border-blue-500');
                    stockTab.classList.remove('text-gray-400', 'border-transparent');

                    forexTab.classList.remove('text-blue-500', 'border-blue-500');
                    forexTab.classList.add('text-gray-400', 'border-transparent');
                }
            }

            forexTab.addEventListener('click', () => switchTab('forex'));
            stockTab.addEventListener('click', () => switchTab('stock'));

            // Initialize default tab
            switchTab('forex');

            // --- SEARCH FILTER ---
            const searchInput = document.getElementById('forex-search');
            if(searchInput) {
                searchInput.addEventListener('keyup', function() {
                    const value = this.value.toLowerCase();
                    const rows = document.querySelectorAll('#forex-table-body tr');

                    rows.forEach(row => {
                        const symbolCell = row.querySelector('td:nth-child(2)');
                        if(symbolCell) {
                            const symbol = symbolCell.textContent.toLowerCase();
                            if (symbol.includes(value)) {
                                row.style.display = '';
                            } else {
                                row.style.display = 'none';
                            }
                        }
                    });
                });
            }
        });
    </script>
    @endpush
</x-app-layout>
