<x-admin-layout>
    <div class="box">
        <div class="box-header">
            <h4 class="font-bold text-3xl">Claimed Shares</h4>
        </div>

        <div class="box-body">
            <div class="table-responsive">
                <table id="generic_table" class="text-fade table table-bordered">
                    <thead>
                        <tr class="text-dark">
                            <th>User</th>
                            <th>Letter Explanation</th>
                            <th>Signed Contract</th>
                            <th>Breach Proof</th>
                            <th>Submitted On</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($claimedShares as $claim)
                        <tr>
                            <td>{{ $claim->user->firstname }} {{ $claim->user->lastname }}</td>
                            <td><a href="/admin/claim_file/{{$claim->letter_explanation }}" target="_blank">View</a></td>
                            <td><a href="/admin/claim_file/{{$claim->signed_contract }}" target="_blank">View</a></td>
                            <td><a href="/admin/claim_file/{{$claim->breach_proof }}" target="_blank">View</a></td>
                            <td>{{ $claim->created_at->setTimezone('Africa/Lagos')->format('h:i a jS M Y') }}</td>
                            <td>
                                <span class="badge badge-{{ $claim->status == 'approved' ? 'success' : ($claim->status == 'pending' ? 'warning' : 'danger') }}">
                                    {{ ucfirst($claim->status) }}
                                </span>
                            </td>
                            <td>
                                @if($claim->status == 'pending')
                                    <x-primary-button data-bs-toggle="modal" data-bs-target="#approve-claim-modal-{{ $claim->id }}">Approve</x-primary-button>
                                    <x-danger-button data-bs-toggle="modal" data-bs-target="#decline-claim-modal-{{ $claim->id }}">Decline</x-danger-button>

                                    <!-- Approval Modal -->
                                    <!-- <div id="approve-claim-modal-{{ $claim->id }}" class="modal fade" tabindex="-1" role="dialog">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Approve Claim</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <p>Are you sure you want to approve this claim?</p>
                                                </div>
                                                <div class="modal-footer flex item-center justify-center gap-4 my-4">
                                                    <form action="{{ route('admin.claimed_shares.approve', $claim->id) }}" method="POST">
                                                        @csrf
                                                        @method('PUT')
                                                        <div class="flex item-center justify-center gap-4 my-4">
                                                            <button type="submit" class="btn btn-light my-2 bg-white">Approve</button>
                                                            <button type="button" class="btn btn-light my-2 bg-gray-300 text-white" data-bs-dismiss="modal">Cancel</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div> -->
                                    <!-- confirm decline -->
                                    <div id="approve-claim-modal-{{$claim->id}}" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content modal-filled bg-success">
                                                <div class="modal-body p-4">
                                                    <div class="text-center">
                                                        <h5 class="modal-title text-3xl font-bold text-white">Approve Claim</h5>
                                                        <h2 class="mt-2">Are you sure you want to Approve this claim?</h2>
                                                        <form action="{{ route('admin.claimed_shares.approve', $claim->id) }}" method="POST" class="flex item-center justify-center gap-4">
                                                            @csrf
                                                            @method('PUT')
                                                            <button type="submit" class="btn btn-light my-2 bg-black text-white">Approve</button>
                                                            <button type="button" class="btn btn-light my-2 bg-white" data-bs-dismiss="modal">No</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div><!-- /.modal-content -->
                                        </div><!-- /.modal-dialog -->
                                    </div><!-- /.modal -->

                                    <!-- decline decline -->
                                    <div id="decline-claim-modal-{{$claim->id}}" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content modal-filled bg-danger">
                                                <div class="modal-body p-4">
                                                    <div class="text-center">
                                                        <h5 class="modal-title text-3xl font-bold">Decline Claim</h5>
                                                        <h2 class="mt-2">Are you sure you want to decline this claim?</h2>
                                                        <form action="{{ route('admin.claimed_shares.decline', $claim->id) }}" method="POST" class="flex item-center justify-center gap-4">
                                                            @csrf
                                                            @method('PUT')
                                                            <button type="submit" class="btn btn-light my-2 bg-white">Yes</button>
                                                            <button type="button" class="btn btn-light my-2 bg-white" data-bs-dismiss="modal">No</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div><!-- /.modal-content -->
                                        </div><!-- /.modal-dialog -->
                                    </div><!-- /.modal -->
                                    <!-- <div id="decline-claim-modal-{{ $claim->id }}" class="modal fade" tabindex="-1" role="dialog">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Decline Claim</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <p>Are you sure you want to decline this claim?</p>
                                                </div>
                                                <div class="modal-footer flex item-center justify-center gap-4 my-4">
                                                    <form action="{{ route('admin.claimed_shares.decline', $claim->id) }}" method="POST">
                                                        @csrf
                                                        @method('PUT')
                                                        <button type="submit" class="btn btn-danger">Decline</button>
                                                    </form>
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div> -->
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    @if (session('success'))
        <x-toast-success>{{ session('success') }}</x-toast-success>
    @endif
    @if (session('success_decline'))
        <x-toast-danger>{{ session('success_decline') }}</x-toast-danger>
    @endif
</x-admin-layout>
